/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.teoz.AbstractTile;
import net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TimeHook;
import net.sourceforge.plantuml.sequencediagram.teoz.YGauge;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ISkinParam;

public class CommunicationExoTile
extends AbstractTile {
    private final LivingSpace livingSpace;
    private final MessageExo message;
    private final Rose skin;
    private final ISkinParam skinParam;
    private final TileArguments tileArguments;
    private final YGauge yGauge;

    @Override
    public Event getEvent() {
        return this.message;
    }

    public CommunicationExoTile(LivingSpace livingSpace, MessageExo message, Rose skin, ISkinParam skinParam, TileArguments tileArguments, YGauge currentY) {
        super(tileArguments.getStringBounder(), currentY);
        this.tileArguments = tileArguments;
        this.livingSpace = livingSpace;
        this.message = message;
        this.skin = skin;
        this.skinParam = skinParam;
        this.yGauge = YGauge.create(currentY.getMax(), this.getPreferredHeight());
    }

    @Override
    public YGauge getYGauge() {
        return this.yGauge;
    }

    @Override
    public double getContactPointRelative() {
        return this.getComponent(this.getStringBounder()).getYPoint(this.getStringBounder());
    }

    private ArrowComponent getComponent(StringBounder stringBounder) {
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        if (this.message.getType().getDirection() == -1) {
            arrowConfiguration = arrowConfiguration.reverse();
        }
        ArrowComponent comp = this.skin.createComponentArrow(this.message.getUsedStyles(), arrowConfiguration, this.skinParam, this.message.getLabelNumbered());
        return comp;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ArrowComponent comp = this.getComponent(stringBounder);
        XDimension2D dim = comp.getPreferredDimension(stringBounder);
        double x1 = this.getPoint1Value(stringBounder);
        double x2 = this.getPoint2Value(stringBounder);
        int level = this.livingSpace.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
        if (level > 0) {
            if (this.message.getType().isRightBorder()) {
                x1 += 5.0 * (double)level;
            } else {
                x2 += 5.0 * (double)(level - 2);
            }
        }
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        MessageExoType type = this.message.getType();
        if (arrowConfiguration.getDecoration1() == ArrowDecoration.CIRCLE && type == MessageExoType.FROM_LEFT) {
            x1 += 6.0;
        }
        if (arrowConfiguration.getDecoration2() == ArrowDecoration.CIRCLE && type == MessageExoType.TO_LEFT) {
            x1 += 6.0;
        }
        if (arrowConfiguration.getDecoration2() == ArrowDecoration.CIRCLE && type == MessageExoType.TO_RIGHT) {
            x2 -= 6.0;
        }
        if (arrowConfiguration.getDecoration1() == ArrowDecoration.CIRCLE && type == MessageExoType.FROM_RIGHT) {
            x2 -= 6.0;
        }
        Area area = Area.create(x2 - x1, dim.getHeight());
        ug = ug.apply(UTranslate.dx(x1));
        comp.drawU(ug, area, (Context2D)((Object)ug));
    }

    private boolean isShortArrow() {
        return this.message.isShortArrow();
    }

    @Override
    public double getPreferredHeight() {
        ArrowComponent comp = this.getComponent(this.getStringBounder());
        XDimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        return dim.getHeight();
    }

    private double getPreferredWidth(StringBounder stringBounder) {
        ArrowComponent comp = this.getComponent(stringBounder);
        XDimension2D dim = comp.getPreferredDimension(stringBounder);
        return dim.getWidth();
    }

    @Override
    public void addConstraints() {
        ArrowComponent comp = this.getComponent(this.getStringBounder());
        XDimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        double width = dim.getWidth();
        if (!this.message.getType().isRightBorder()) {
            this.livingSpace.getPosC(this.getStringBounder()).ensureBiggerThan(this.tileArguments.getXOrigin().addFixed(width));
        }
    }

    @Override
    protected final void callbackY_internal(TimeHook y) {
        super.callbackY_internal(y);
        ArrowComponent comp = this.getComponent(this.getStringBounder());
        XDimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        double arrowY = comp.getStartPoint(this.getStringBounder(), dim).getY();
        this.livingSpace.addStepForLivebox(this.getEvent(), y.getValue() + arrowY);
    }

    private Real getPoint1(StringBounder stringBounder) {
        if (this.message.getType().isRightBorder()) {
            return this.livingSpace.getPosC(stringBounder);
        }
        if (this.isShortArrow()) {
            return this.livingSpace.getPosC(stringBounder).addFixed(-this.getPreferredWidth(stringBounder));
        }
        return this.tileArguments.getXOrigin();
    }

    private double getPoint1Value(StringBounder stringBounder) {
        if (this.message.getType().isRightBorder()) {
            return this.livingSpace.getPosC(stringBounder).getCurrentValue();
        }
        if (this.isShortArrow()) {
            return this.getPoint2Value(stringBounder) - this.getPreferredWidth(stringBounder);
        }
        return this.tileArguments.getBorder1();
    }

    private double getPoint2Value(StringBounder stringBounder) {
        if (this.message.getType().isRightBorder()) {
            if (this.isShortArrow()) {
                return this.getPoint1Value(stringBounder) + this.getPreferredWidth(stringBounder);
            }
            return this.tileArguments.getBorder2();
        }
        return this.livingSpace.getPosC(stringBounder).getCurrentValue();
    }

    @Override
    public Real getMinX() {
        return this.getPoint1(this.getStringBounder());
    }

    @Override
    public Real getMaxX() {
        ArrowComponent comp = this.getComponent(this.getStringBounder());
        XDimension2D dim = comp.getPreferredDimension(this.getStringBounder());
        double width = dim.getWidth();
        return this.getPoint1(this.getStringBounder()).addFixed(width);
    }
}

