/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.elk;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.abel.CucaNote;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkArrow;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.ICucaDiagram;
import net.sourceforge.plantuml.eggs.QuoteUtils;
import net.sourceforge.plantuml.elk.MyElkDrawing;
import net.sourceforge.plantuml.elk.proxy.core.RecursiveGraphLayoutEngine;
import net.sourceforge.plantuml.elk.proxy.core.math.ElkPadding;
import net.sourceforge.plantuml.elk.proxy.core.options.CoreOptions;
import net.sourceforge.plantuml.elk.proxy.core.options.Direction;
import net.sourceforge.plantuml.elk.proxy.core.options.EdgeLabelPlacement;
import net.sourceforge.plantuml.elk.proxy.core.options.HierarchyHandling;
import net.sourceforge.plantuml.elk.proxy.core.options.NodeLabelPlacement;
import net.sourceforge.plantuml.elk.proxy.core.util.NullElkProgressMonitor;
import net.sourceforge.plantuml.elk.proxy.graph.ElkEdge;
import net.sourceforge.plantuml.elk.proxy.graph.ElkLabel;
import net.sourceforge.plantuml.elk.proxy.graph.ElkNode;
import net.sourceforge.plantuml.elk.proxy.graph.util.ElkGraphUtil;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.skin.AlignmentParam;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.ClusterHeader;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.GeneralImageBuilder;
import net.sourceforge.plantuml.svek.GraphvizCrash;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.image.EntityImageNoteLink;
import net.sourceforge.plantuml.utils.Position;

public class CucaDiagramFileMakerElk
implements CucaDiagramFileMaker {
    private final ICucaDiagram diagram;
    private final StringBounder stringBounder;
    private final DotStringFactory dotStringFactory;
    private final Map<Entity, ElkNode> nodes = new LinkedHashMap<Entity, ElkNode>();
    private final Map<Entity, ElkNode> clusters = new LinkedHashMap<Entity, ElkNode>();
    private final Map<Link, ElkEdge> edges = new LinkedHashMap<Link, ElkEdge>();

    public CucaDiagramFileMakerElk(ICucaDiagram diagram, StringBounder stringBounder) {
        this.diagram = diagram;
        this.stringBounder = stringBounder;
        this.dotStringFactory = new DotStringFactory(stringBounder, diagram);
    }

    public final StyleSignature getDefaultStyleDefinitionArrow(Stereotype stereotype, SName styleName) {
        StyleSignature result = StyleSignatureBasic.of(SName.root, SName.element, styleName, SName.arrow);
        if (stereotype != null) {
            result = result.withTOBECHANGED(stereotype);
        }
        return result;
    }

    private FontConfiguration getFontForLink(Link link, ISkinParam skinParam) {
        SName styleName = skinParam.getUmlDiagramType().getStyleName();
        Style style = this.getDefaultStyleDefinitionArrow(link.getStereotype(), styleName).getMergedStyle(link.getStyleBuilder());
        return style.getFontConfiguration(skinParam.getIHtmlColorSet());
    }

    private HorizontalAlignment getMessageTextAlignment(UmlDiagramType umlDiagramType, ISkinParam skinParam) {
        if (umlDiagramType == UmlDiagramType.STATE) {
            return skinParam.getHorizontalAlignment(AlignmentParam.stateMessageAlignment, null, false, null);
        }
        return skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER);
    }

    private TextBlock addVisibilityModifier(TextBlock block, Link link, ISkinParam skinParam) {
        VisibilityModifier visibilityModifier = link.getVisibilityModifier();
        if (visibilityModifier != null) {
            Rose rose = new Rose();
            HColor fore = rose.getHtmlColor(skinParam, visibilityModifier.getForeground());
            TextBlock visibility = visibilityModifier.getUBlock(skinParam.classAttributeIconSize(), fore, null, false);
            visibility = TextBlockUtils.withMargin(visibility, 0.0, 1.0, 2.0, 0.0);
            block = TextBlockUtils.mergeLR(visibility, block, VerticalAlignment.CENTER);
        }
        double marginLabel = 1.0;
        return TextBlockUtils.withMargin(block, 1.0, 1.0);
    }

    private LinkArrow getLinkArrow(Link link) {
        return link.getLinkArrow();
    }

    private TextBlock getLabel(Link link) {
        CucaNote note;
        TextBlock labelOnly;
        ISkinParam skinParam = this.diagram.getSkinParam();
        double marginLabel = 1.0;
        UmlDiagramType type = skinParam.getUmlDiagramType();
        FontConfiguration font = this.getFontForLink(link, skinParam);
        if (Display.isNull(link.getLabel())) {
            labelOnly = TextBlockUtils.EMPTY_TEXT_BLOCK;
            if (this.getLinkArrow(link) != LinkArrow.NONE_OR_SEVERAL) {
                // empty if block
            }
        } else {
            HorizontalAlignment alignment = this.getMessageTextAlignment(type, skinParam);
            boolean hasSeveralGuideLines = link.getLabel().hasSeveralGuideLines();
            TextBlock block = link.getLabel().create0(font, alignment, skinParam, skinParam.maxMessageSize(), CreoleMode.SIMPLE_LINE, null, null);
            labelOnly = this.addVisibilityModifier(block, link, skinParam);
            if (this.getLinkArrow(link) == LinkArrow.NONE_OR_SEVERAL || !hasSeveralGuideLines) {
                // empty if block
            }
        }
        if ((note = link.getNote()) == null) {
            if (!TextBlockUtils.isEmpty(labelOnly, this.stringBounder)) {
                labelOnly = TextBlockUtils.withMargin(labelOnly, 1.0, 1.0);
            }
            return labelOnly;
        }
        EntityImageNoteLink noteOnly = new EntityImageNoteLink(note.getDisplay(), note.getColors(), skinParam, link.getStyleBuilder());
        if (note.getPosition() == Position.LEFT) {
            return TextBlockUtils.mergeLR(noteOnly, labelOnly, VerticalAlignment.CENTER);
        }
        if (note.getPosition() == Position.RIGHT) {
            return TextBlockUtils.mergeLR(labelOnly, noteOnly, VerticalAlignment.CENTER);
        }
        if (note.getPosition() == Position.TOP) {
            return TextBlockUtils.mergeTB((TextBlock)noteOnly, labelOnly, HorizontalAlignment.CENTER);
        }
        return TextBlockUtils.mergeTB(labelOnly, noteOnly, HorizontalAlignment.CENTER);
    }

    private TextBlock getQuantifier(Link link, int n) {
        String tmp;
        String string = tmp = n == 1 ? link.getQuantifier1() : link.getQuantifier2();
        if (tmp == null) {
            return null;
        }
        ISkinParam skinParam = this.diagram.getSkinParam();
        FontConfiguration labelFont = FontConfiguration.create(skinParam, FontParam.ARROW, null);
        TextBlock label = Display.getWithNewlines(tmp).create(labelFont, skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER), skinParam);
        if (TextBlockUtils.isEmpty(label, this.stringBounder)) {
            return null;
        }
        return label;
    }

    public static XPoint2D getPosition(ElkNode elkNode) {
        ElkNode parent = elkNode.getParent();
        double x = elkNode.getX();
        double y = elkNode.getY();
        if (parent == null || parent.getLabels().size() == 0) {
            return new XPoint2D(x, y);
        }
        XPoint2D parentPosition = CucaDiagramFileMakerElk.getPosition(parent);
        return new XPoint2D(parentPosition.getX() + x, parentPosition.getY() + y);
    }

    private Collection<Entity> getUnpackagedEntities() {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity ent : this.diagram.getEntityFactory().leafs()) {
            if (this.diagram.getEntityFactory().getRootGroup() != ent.getParentContainer()) continue;
            result.add(ent);
        }
        return result;
    }

    private ElkNode getElkNode(Entity entity) {
        ElkNode node = this.nodes.get(entity);
        if (node == null) {
            node = this.clusters.get(entity);
        }
        return node;
    }

    @Override
    public ImageData createFile(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        try {
            ElkNode root = ElkGraphUtil.createGraph();
            root.setProperty(CoreOptions.DIRECTION, Direction.DOWN);
            root.setProperty(CoreOptions.HIERARCHY_HANDLING, HierarchyHandling.INCLUDE_CHILDREN);
            this.printAllSubgroups(root, this.diagram.getRootGroup());
            this.printEntities(root, this.getUnpackagedEntities());
            this.manageAllEdges();
            new RecursiveGraphLayoutEngine().layout(root, new NullElkProgressMonitor());
            MinMax minMax = TextBlockUtils.getMinMax(new MyElkDrawing(this.dotStringFactory, this.diagram, null, this.clusters, this.edges, this.nodes), this.stringBounder, false);
            MyElkDrawing drawable = new MyElkDrawing(this.dotStringFactory, this.diagram, minMax, this.clusters, this.edges, this.nodes);
            return this.diagram.createImageBuilder(fileFormatOption).drawable(drawable).write(os);
        }
        catch (Throwable e) {
            UmlDiagram.exportDiagramError(os, e, fileFormatOption, this.diagram.seed(), this.diagram.getMetadata(), this.diagram.getFlashData(), CucaDiagramFileMakerElk.getFailureText3(e));
            return ImageDataSimple.error(e);
        }
    }

    private void printAllSubgroups(ElkNode cluster, Entity group) {
        for (Entity g : this.diagram.getChildrenGroups(group)) {
            if (g.isRemoved()) continue;
            if (this.diagram.isEmpty(g) && g.getGroupType() == GroupType.PACKAGE) {
                g.muteToType(LeafType.EMPTY_PACKAGE);
                this.prinEntity(g, cluster);
                continue;
            }
            ElkNode elkCluster = ElkGraphUtil.createNode(cluster);
            elkCluster.setProperty(CoreOptions.DIRECTION, Direction.DOWN);
            ClusterHeader clusterHeader = new ClusterHeader(g, this.diagram.getSkinParam(), this.diagram, this.stringBounder);
            int titleAndAttributeHeight = clusterHeader.getTitleAndAttributeHeight();
            double topPadding = Math.max(25, titleAndAttributeHeight) + 15;
            elkCluster.setProperty(CoreOptions.PADDING, new ElkPadding(topPadding, 15.0, 15.0, 15.0));
            ElkLabel label = ElkGraphUtil.createLabel(elkCluster);
            label.setText("C");
            this.clusters.put(g, elkCluster);
            this.printSingleGroup(g);
        }
    }

    private void printSingleGroup(Entity g) {
        if (g.getGroupType() == GroupType.CONCURRENT_STATE) {
            return;
        }
        this.printEntities(this.clusters.get(g), g.leafs());
        this.printAllSubgroups(this.clusters.get(g), g);
    }

    private void printEntities(ElkNode parent, Collection<Entity> entities) {
        for (Entity ent : entities) {
            if (ent.isRemoved()) continue;
            this.prinEntity(ent, parent);
        }
    }

    private void manageAllEdges() {
        for (Link link : this.diagram.getLinks()) {
            this.manageSingleEdge(link);
        }
    }

    private void prinEntity(Entity ent, ElkNode parent) {
        IEntityImage image = this.printEntityInternal(ent);
        XDimension2D dimension = image.calculateDimension(this.stringBounder);
        SvekNode node = this.getBibliotekon().createNode(ent, image, this.dotStringFactory.getColorSequence(), this.stringBounder);
        this.dotStringFactory.addNode(node);
        ElkNode elkNode = ElkGraphUtil.createNode(parent);
        elkNode.setDimensions(dimension.getWidth(), dimension.getHeight());
        ElkLabel label = ElkGraphUtil.createLabel(elkNode);
        label.setText("X");
        double VERY_STRANGE_OFFSET = 10.0;
        label.setDimensions(dimension.getWidth(), dimension.getHeight() - 10.0);
        label.setProperty(CoreOptions.NODE_LABELS_PLACEMENT, EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.H_CENTER, NodeLabelPlacement.V_CENTER));
        this.nodes.put(ent, elkNode);
    }

    private void manageSingleEdge(Link link) {
        XDimension2D dim;
        ElkLabel edgeLabel;
        ElkNode node1 = this.getElkNode(link.getEntity1());
        ElkNode node2 = this.getElkNode(link.getEntity2());
        ElkEdge edge = ElkGraphUtil.createSimpleEdge(node1, node2);
        TextBlock labelLink = this.getLabel(link);
        if (labelLink != null) {
            edgeLabel = ElkGraphUtil.createLabel(edge);
            dim = labelLink.calculateDimension(this.stringBounder);
            edgeLabel.setText("X");
            edgeLabel.setDimensions(dim.getWidth(), dim.getHeight());
            edge.setProperty(CoreOptions.EDGE_LABELS_INLINE, true);
        }
        if (link.getQuantifier1() != null) {
            edgeLabel = ElkGraphUtil.createLabel(edge);
            dim = this.getQuantifier(link, 1).calculateDimension(this.stringBounder);
            edgeLabel.setText("1");
            edgeLabel.setDimensions(dim.getWidth(), dim.getHeight());
            edgeLabel.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, EdgeLabelPlacement.TAIL);
            edge.setProperty(CoreOptions.EDGE_LABELS_INLINE, true);
        }
        if (link.getQuantifier2() != null) {
            edgeLabel = ElkGraphUtil.createLabel(edge);
            dim = this.getQuantifier(link, 2).calculateDimension(this.stringBounder);
            edgeLabel.setText("2");
            edgeLabel.setDimensions(dim.getWidth(), dim.getHeight());
            edgeLabel.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, EdgeLabelPlacement.HEAD);
            edge.setProperty(CoreOptions.EDGE_LABELS_INLINE, true);
        }
        this.edges.put(link, edge);
    }

    private static List<String> getFailureText3(Throwable exception) {
        Logme.error(exception);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("An error has occured : " + exception);
        String quote = StringUtils.rot(QuoteUtils.getSomeQuote());
        strings.add("<i>" + quote);
        strings.add(" ");
        GraphvizCrash.addProperties(strings);
        strings.add(" ");
        strings.add("Sorry, ELK intregration is really alpha feature...");
        strings.add(" ");
        strings.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> or");
        strings.add("post to <b>https://plantuml.com/qa</b> to solve this issue.");
        strings.add(" ");
        return strings;
    }

    private Bibliotekon getBibliotekon() {
        return this.dotStringFactory.getBibliotekon();
    }

    private IEntityImage printEntityInternal(Entity ent) {
        if (ent.isRemoved()) {
            throw new IllegalStateException();
        }
        if (ent.getSvekImage() == null) {
            ISkinParam skinParam = this.diagram.getSkinParam();
            if (skinParam.sameClassWidth()) {
                System.err.println("NOT YET IMPLEMENED");
            }
            return GeneralImageBuilder.createEntityImageBlock(ent, skinParam, this.diagram.isHideEmptyDescriptionForState(), this.diagram, this.getBibliotekon(), null, this.diagram.getUmlDiagramType(), this.diagram.getLinks());
        }
        return ent.getSvekImage();
    }

    @Override
    public void createOneGraphic(UGraphic ug) {
        throw new UnsupportedOperationException();
    }
}

