/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import java.util.List;
import net.sourceforge.plantuml.Lazy;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.wbs.WBSDiagram;

public class CommandWBSItemMultiline
extends CommandMultilines2<WBSDiagram> {
    private static final Lazy<Pattern2> END = new Lazy<Pattern2>(() -> Pattern2.cmpile("^(.*);\\s*(\\<\\<(.+)\\>\\>)?$"));

    public CommandWBSItemMultiline() {
        super(CommandWBSItemMultiline.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH, END);
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandWBSItemMultiline.class.getName(), RegexLeaf.start(), new RegexLeaf(1, "TYPE", "([ \t]*[*+-]+)"), new RegexOptional((IRegex)new RegexLeaf(1, "BACKCOLOR", "\\[(#\\w+)\\]")), new RegexLeaf(1, "SHAPE", "(_)?"), new RegexLeaf(":"), new RegexLeaf(1, "DATA", "(.*)"), RegexLeaf.end());
    }

    static IRegex getRegexConcatOld() {
        return RegexConcat.build(CommandWBSItemMultiline.class.getName(), RegexLeaf.start(), new RegexLeaf(1, "TYPE", "([ \t]*[*+-]+)"), new RegexOptional((IRegex)new RegexLeaf(1, "BACKCOLOR", "\\[(#\\w+)\\]")), new RegexLeaf(1, "SHAPE", "(_)?"), new RegexLeaf(1, "DIRECTION", "([<>])?"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "LABEL", "([^%s].*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(WBSDiagram diagram, BlocLines lines, ParserPass currentPass) throws NoSuchColorException {
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        List<String> lineLast = StringUtils.getSplit(this.getEndPattern(), lines.getLast().getString());
        lines = lines.removeStartingAndEnding(line0.get("DATA", 0), 1);
        String stereotype = lineLast.get(1);
        if (stereotype != null) {
            lines = lines.overrideLastLine(lineLast.get(0));
        }
        String type = line0.get("TYPE", 0);
        String stringColor = line0.get("BACKCOLOR", 0);
        HColor backColor = null;
        if (stringColor != null) {
            backColor = diagram.getSkinParam().getIHtmlColorSet().getColor(stringColor);
        }
        Direction dir = Direction.RIGHT;
        return diagram.addIdea(null, backColor, diagram.getSmartLevel(type), lines.toDisplay(), Stereotype.build(stereotype), dir, IdeaShape.fromDesc(line0.get("SHAPE", 0)));
    }
}

