// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.graphic;

import jcckit.util.ConfigParameters;
import jcckit.util.FactoryException;

/**
 *  Anchor of a graphical element. There exist only the three
 *  instances {@link #LEFT_BOTTOM}, {@link #CENTER}, and
 *  {@link #RIGHT_TOP}.
 *  <p>
 *  The anchor factor can be used in a position formular. Its value
 *  for the three instances reads:
 *  <p>
 *  <center>
 *  <table border=1 cellpadding=5>
 *  <tr><th>Instance</th><th>Factor</th></tr>
 *  <tr><td><tt>LEFT_BOTTOM</tt></td><td>0</td></tr>
 *  <tr><td><tt>CENTER</tt></td><td>1</td></tr>
 *  <tr><td><tt>RIGHT_TOP</tt></td><td>2</td></tr>
 *  </table>
 *  </center>
 *
 *  @author Franz-Josef Elmer
 */
public class Anchor {
  /** Anchor constant. */
  public static final Anchor LEFT_BOTTOM = new Anchor(0),
                             CENTER = new Anchor(1),
                             RIGHT_TOP = new Anchor(2);
  private static final String LEFT_VALUE = "left",
                              RIGHT_VALUE = "right",
                              CENTER_VALUE = "center",
                              TOP_VALUE = "top",
                              BOTTOM_VALUE = "bottom";

  /**
   *  Returns form the specified configuration parameters the
   *  horizontal anchor defined by the specified key or the
   *  specified default value.
   *  @param config Configuration parameters.
   *  @param key The key of the anchor. <tt>null</tt> is not allowed.
   *  @param defaultValue The default value.
   *  @return one of the three instances of <tt>Anchor</tt>.
   *  @throws FactoryException if the value of <tt>key</tt> is
   *          neither <tt>left</tt>, <tt>center</tt>,
   *          nor <tt>right</tt>. 
   *          Note, that {@link FactoryException#getClassName()} 
   *          returns the invalid value.
   */
  public static Anchor getHorizontalAnchor(ConfigParameters config, String key,
                                           Anchor defaultValue) {
    Anchor result = defaultValue;
    String anchor = config.get(key, null);
    if (anchor != null) {
      if (anchor.equals(LEFT_VALUE)) {
        result = Anchor.LEFT_BOTTOM;
      } else if (anchor.equals(CENTER_VALUE)) {
        result = Anchor.CENTER;
      } else if (anchor.equals(RIGHT_VALUE)) {
        result = Anchor.RIGHT_TOP;
      } else {
        throw new FactoryException(config, key, "Invalid horizontal anchor.");
      }
    }
    return result;
  }

  /**
   *  Returns form the specified configuration parameters the
   *  vertical anchor defined by the specified key or the
   *  specified default value.
   *  @param config Configuration parameters.
   *  @param key The key of the anchor. <tt>null</tt> is not allowed.
   *  @param defaultValue The default value.
   *  @return one of the three instances of <tt>Anchor</tt>.
   *  @throws FactoryException if the value of <tt>key</tt> is
   *          neither <tt>top</tt>, <tt>center</tt>,
   *          nor <tt>bottom</tt>.
   *          Note, that {@link FactoryException#getClassName()} 
   *          returns the invalid value.
   */
  public static Anchor getVerticalAnchor(ConfigParameters config, String key,
                                  Anchor defaultValue) {
    Anchor result = defaultValue;
    String anchor = config.get(key, null);
    if (anchor != null) {
      if (anchor.equals(BOTTOM_VALUE)) {
        result = Anchor.LEFT_BOTTOM;
      } else if (anchor.equals(CENTER_VALUE)) {
        result = Anchor.CENTER;
      } else if (anchor.equals(TOP_VALUE)) {
        result = Anchor.RIGHT_TOP;
      } else {
        throw new FactoryException(config, key, "Invalid vertcal anchor.");
      }
    }
    return result;
  }

  private final int _factor;

  private Anchor(int factor) {
    _factor = factor;
  }

  /** Returns the factor. */
  public int getFactor() {
    return _factor;
  }
}

