// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.plot;

import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalElement;
import jcckit.util.ConfigParameters;
import jcckit.util.Factory;

/**
 * Abstract superclass of all {@link SymbolFactory SymbolFactories}.
 * Subclasses have to implement {@link #createPlainSymbol createPlainSymbol()}.
 *
 * @author Franz-Josef Elmer
 */
public abstract class AbstractSymbolFactory implements SymbolFactory {
  /** Size of all symbols. */
  protected final double _size;
  
  /** Attributes of all symbols. */
  protected final GraphicAttributes _attributes;

  /**
   * Creates an instance from the specified configuration parameters.
   * <table border=1 cellpadding=5>
   * <tr><th>Key &amp; Default Value</th><th>Type</th><th>Mandatory</th>
   *     <th>Description</th></tr>
   * <tr><td><tt>size = </tt>0.01</td>
   *     <td><tt>double</tt></td><td>no</td>
   *     <td>Size of the symbol in device-independent units.</td></tr>
   * <tr><td><tt>attributes</tt></td>
   *     <td><tt>ConfigParameters</tt></td><td>no</td>
   *     <td>Configuration parameters for the attributes of the symbol.
   *         <tt>className</tt> has to be a class which is an instance of
   *         {@link GraphicAttributes}.</td></tr>
   * </table>
   */
  public AbstractSymbolFactory(ConfigParameters config) {
    _size = config.getDouble(SIZE_KEY, DEFAULT_SIZE);
    _attributes = (GraphicAttributes) Factory.createOrGet(
                                        config.getNode(ATTRIBUTES_KEY), null);
  }

  /** 
   * Creates a symbol.
   * Evaluate <tt>hintFromPreviousPoint</tt> if it is a {@link AttributesHint}.
   * Calls {@link #createSymbol(GraphPoint, GraphicAttributes, Hint, Hint)}.
   * @param point Symbol position.
   * @param hintFromPreviousPoint Hint from the previous point.
   * @param hintFromPreviousCurve Hint from the previous curve.
   */
  public Symbol createSymbol(GraphPoint point, Hint hintFromPreviousPoint,
                             Hint hintFromPreviousCurve) {
    GraphicAttributes attributes = _attributes;
    Hint hintForNextPoint = hintFromPreviousPoint;
    if (hintFromPreviousPoint instanceof AttributesHint) {
      attributes = ((AttributesHint) hintFromPreviousPoint).getAttributes();
      hintForNextPoint 
          = ((AttributesHint) hintFromPreviousPoint).getNextHint();
    }
    return createSymbol(point,  attributes, hintForNextPoint,
                        hintFromPreviousCurve);
  }

  /**
   * Creates a symbol.
   * Uses {@link #createPlainSymbol createPlainSymbol()}.
   * @param point Symbol position.
   * @param attributes Symbol attributes.
   * @param hintForNextPoint Hint for the next point. Will be delivered
   *        unchanged in the return <tt>Symbol</tt> object.
   * @param hintFromPreviousCurve Hint from the previous curve.
   *        Will be delivered unchanged in the return <tt>Symbol</tt> object.
   *        Subclasses may override this behavior.
   */
  protected Symbol createSymbol(GraphPoint point, GraphicAttributes attributes,
                                Hint hintForNextPoint, 
                                Hint hintFromPreviousCurve) {
    return new Symbol(createPlainSymbol(point, _size, attributes),
                      hintForNextPoint, hintFromPreviousCurve);
  }

  /**
   * Creates a symbol for the legend at the specified position.
   * Uses {@link #createPlainSymbol createPlainSymbol()} 
   * @param centerPosition Center position of the symbol.
   * @param size The size of the symbol. Will be ignored because the value
   *         given in the constructor will be used.
   */
  public GraphicalElement createLegendSymbol(GraphPoint centerPosition,
                                             double size) {
    return createPlainSymbol(centerPosition, _size, _attributes);
  }

  /**
   * Creates the graphical element of the plain symbol.
   * @param centerPosition Center position of the symbol.
   * @param size The size of the symbol.
   * @param attributes The attributes of the symbol.
   */
  protected abstract GraphicalElement createPlainSymbol(
      GraphPoint centerPosition, double size, GraphicAttributes attributes);
}
