// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.plot;

/**
 * A plot event signales some changes of a {@link Plot}.
 * It has three attributes:
 * <ul><li><b>source</b>: Indicates the <tt>Plot</tt> instance responsible 
 *         for this event.
 *     <li><b>type</b>: The type of event.
 *     <li><b>message</b>: The message object. Its meaning depends on the 
 *         type of event:
 *         <table border=1 cellpadding=5>
 *           <tr><th>Type</th><th>Meaning of the message object</th></tr>
 *           <tr><td>{@link PlotEventType#DATA_PLOT_CONNECTED}, 
 *                   {@link PlotEventType#DATA_PLOT_DISCONNECTED}</td>
 *               <td>The {@link jcckit.data.DataPlot} (dis)connected with the 
 *                   {@link Plot} instance specified by the source.</td>
 *           <tr><td>{@link PlotEventType#DATA_PLOT_CHANGED}</td>
 *               <td>An <tt>Integer</tt> indicating the lowest index of 
 *                   those curves which have been changed.</td>
 *           <tr><td>{@link PlotEventType#DATA_CURVE_CHANGED}</td>
 *               <td>An <tt>Integer</tt> indicating the index of the curve
 *                   which has been changed.</td>
 *         </table>
 * </ul>
 *  
 *
 * @author Franz-Josef Elmer
 */
public class PlotEvent {
  private final Plot _source;
  private final PlotEventType _type;
  private final Object _message;

  /** 
   * Creates a new event for the specified source, type, and message. 
   * @param source Plot causing this event.
   * @param type Type of the event. Possible values are
   *        {@link PlotEventType#DATA_PLOT_CHANGED}, 
   *        {@link PlotEventType#DATA_CURVE_CHANGED}, 
   *        {@link PlotEventType#DATA_PLOT_CONNECTED}, and 
   *        {@link PlotEventType#DATA_PLOT_DISCONNECTED}.
   * @param message Message object. Can be <tt>null</tt>
   */
  public PlotEvent(Plot source, PlotEventType type, Object message) {
    _source = source;
    _type = type;
    _message = message;
  }

  /** Returns the source of this event. */
  public Plot getSource() {
    return _source;
  }

  /** 
   * Returns the event type. 
   * @return either {@link PlotEventType#DATA_PLOT_CHANGED}, 
   *         {@link PlotEventType#DATA_CURVE_CHANGED},
   *         {@link PlotEventType#DATA_PLOT_CONNECTED}, or 
   *         {@link PlotEventType#DATA_PLOT_DISCONNECTED}.
   */
  public PlotEventType getType() {
    return _type;
  }

  /** Returns the message object. */
  public Object getMessage() {
    return _message;
  }
}
