// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.plot;

import java.util.Properties;
import java.util.StringTokenizer;

import jcckit.graphic.ClippingShape;
import jcckit.util.ConfigParameters;
import jcckit.util.PropertiesBasedConfigData;

/**
 * Factory for {@link SimpleCurve SimpleCurves}.
 * 
 * @author Franz-Josef Elmer
 */
public class SimpleCurveFactory implements CurveFactory {
  /** Configuration parameter key. */
  public static final String DEFINITIONS_KEY = "definitions";

  private ConfigParameters[] _configs = new ConfigParameters[] 
      {new ConfigParameters(new PropertiesBasedConfigData(new Properties()))};

  /**
   * Creates an instance from the specified configuration parameter.
   * <table border=1 cellpadding=5>
   * <tr><th>Key &amp; Default Value</th><th>Type</th><th>Mandatory</th>
   *     <th>Description</th></tr>
   * <tr><td><tt>definitions = </tt><i>one empty</i> <tt>ConfigParameters</tt> 
   *         <i>instance</i></td>
   *     <td><tt>String[]</tt></td><td>no</td>
   *     <td>Keys of subtrees defining {@link ConfigParameters}
   *         used by the {@link SimpleCurve#SimpleCurve constructor} of 
   *         {@link SimpleCurve}.</td></tr>
   * </table>
   */
  public SimpleCurveFactory(ConfigParameters config) {
    String value = config.get(DEFINITIONS_KEY, null);
    if (value != null) {
      StringTokenizer tokenizer = new StringTokenizer(value);
      _configs = new ConfigParameters[tokenizer.countTokens()];
      for (int i = 0; i < _configs.length; i++) {
        _configs[i] = config.getNode(tokenizer.nextToken());
      }
    }
  }

  /**
   * Creates an instance of {@link SimpleCurve}.
   * @param curveIndex Index of the curve. Will be used to select the 
   *        {@link ConfigParameters} object and the line attributes. 
   *        In addition it will be used to calculate the y-coordinate 
   *        of the legend symbol.
   * @param numberOfCurves Number of curves. Will be needed to calculate 
   *        the y-coordinate of the legend symbol.
   * @param clippingShape The clipping shape.
   * @param legend The legend. Will be needed to create the legend symbol.
   */
  public Curve create(int curveIndex,  int numberOfCurves,
                      ClippingShape clippingShape, Legend legend) {
    return new SimpleCurve(_configs[curveIndex % _configs.length], curveIndex,
                           numberOfCurves, clippingShape, legend);
  }
}
