// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.plot;

import java.util.StringTokenizer;

import jcckit.util.ConfigParameters;
import jcckit.util.TicLabelFormat;

/**
 * Map of number intervals onto a text label. The map is defined by a
 * map description string provided by configuration data.
 * <p>
 * The map description is a list
 * of conditions separated by ';'. The conditions are tested from left to
 * right until a condition is fulfilled for the tic value. If no condition
 * is fullfilled a '?' will be returned.
 * <p>
 * A condition description has one of the following forms:
 * <pre><tt><i>&lt;label&gt;</i></tt></pre>
 * <pre><tt><i>&lt;number&gt;</i>=<i>&lt;label&gt;</i></tt></pre>
 * <pre><tt><i>&lt;number1&gt;</i>:<i>&lt;number2&gt;</i>=<i>&lt;label&gt;</i></tt></pre>
 * <p>
 * The first type of condition is always fulfilled. It will return
 * <tt><i>&lt;label&gt;</i></tt>. This is a kind of else condtion
 * which is put at the end of the condition list.
 * <p>
 * The second form maps a particular number onto a label. In order to be
 * equal with the sepcified number the tic value should not deviate more
 * than 1 ppm (part per millions) from <tt><i>&lt;number&gt;</i></tt>.
 * <p>
 * The third form maps an interval onto a label. The condition reads
 * <p>
 * <tt><i>&lt;number1&gt;</i></tt>&nbsp;&lt;=&nbsp;tic&nbsp;label&nbsp;&lt;&nbsp;<tt><i>&lt;number2&gt;</i></tt>
 * <p>
 * Examples:
 * <pre><tt>
 * 1=monday;2=tuesday;3=wednesday;4=thursday;5=friday;6=saturday;7=sunday
 * 0.5:1.5=I; 1.5:2.5 = II; 2.5:3.5 = III; the rest
 * </tt></pre>
 *
 * @author Franz-Josef Elmer
 */
public class TicLabelMap implements TicLabelFormat {
  public static final String MAP_KEY = "map";

  private static class MapItem {
    private double _min = Double.MIN_VALUE;
    private double _max = Double.MAX_VALUE;
    private final String label;
    public MapItem(String item) {
      int index = item.indexOf('=');
      if (index < 0) {
        label = item;
      } else {
        label = item.substring(index + 1).trim();
        item = item.substring(0, index).trim();
        index = item.indexOf(':');
        if (index < 0) {
          _min = Double.parseDouble(item);
          _max = _min == 0 ? Double.MIN_VALUE : _min * 1.000001d;
          _min = _min * 0.999999d;
          if (_min > _max) {
            double z = _min;
            _min = _max;
            _max = z;
          }
        } else {
          _min = Double.parseDouble(item.substring(0, index));
          _max = Double.parseDouble(item.substring(index + 1));
        }
      }
    }
    public boolean isInside(double value) {
      return value >= _min && value < _max;
    }
  }

  private final MapItem[] _map;

  /**
   * Creates an instance from the specified configuration parameters.
   * <table border=1 cellpadding=5>
   * <tr><th>Key &amp; Default Value</th><th>Type</th><th>Mandatory</th>
   *     <th>Description</th></tr>
   * <tr><td><tt>map</tt></td>
   *     <td><tt>String</tt></td><td>yes</td>
   *     <td>Map description as explained above.</td></tr>
   * </table>
   */
  public TicLabelMap(ConfigParameters config) {
    StringTokenizer tokenizer = new StringTokenizer(config.get(MAP_KEY), ";");
    _map = new MapItem[tokenizer.countTokens()];
    for (int i = 0; i < _map.length; i++)
    {
      String item = tokenizer.nextToken();
      try {
        _map[i] = new MapItem(item.trim());
      } catch (NumberFormatException e) {
        throw new NumberFormatException("Item '" + item + "' of "
            + config.getFullKey(MAP_KEY) + " has an invalid number.");
      }
    }
  }

  /**
   * Maps the specified tic value onto a text label in accordance
   * with the map description.
   */
  public String form(double ticValue) {
    String result = "?";
    for (int i = 0; i < _map.length; i++) {
      if (_map[i].isInside(ticValue)) {
        result = _map[i].label;
        break;
      }
    }
    return result;
  }
}
