// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.renderer;

import java.awt.Graphics2D;

import jcckit.graphic.Anchor;
import jcckit.graphic.ClippingRectangle;
import jcckit.graphic.GraphPoint;

/**
 *  Transformation between device-independent coordinates
 *  and standard Java coordinates. The aspect-ratio will
 *  be the same. The position in the canvas is determined by a
 *  {@link jcckit.graphic.Rectangle Rectangle} defining a (virtual)
 *  paper which is placed in the canvas according to an anchor point.
 *  Depending on the aspect ratio  of the canvas the paper width or
 *  height occupies the canvas width or height.
 *
 *  @author Franz-Josef Elmer
 */
public class Transformation {
    // ::remove folder when __HAXE__
  private final double _scale, _x0, _y0;
  
  public String toString() {
		return "_scale=" + _scale + " _x0=" + _x0 + " _y0=" + _y0;
	}

  /**
   *  Creates an instance for the specified canvas size, paper size,
   *  and anchor points of the paper.
   *  @param width Width of the canvas.
   *  @param height Height of the canvas.
   *  @param paper Rectangle defining the paper in device-independent
   *         coordinates.
   *  @param horizontalAnchor Horizontal anchor of the paper in the canvas.
   *  @param verticalAnchor Vertical anchor of the paper in the canvas.
   */
  public Transformation(int width, int height, ClippingRectangle paper,
                        Anchor horizontalAnchor, Anchor verticalAnchor) {
    double pWidth = paper.getMaxX() - paper.getMinX();
    double pHeight = paper.getMaxY() - paper.getMinY();
    _scale = Math.min(width / pWidth, height / pHeight);
    _x0 = 0.5 * horizontalAnchor.getFactor() * (width - _scale * pWidth)
          - _scale * paper.getMinX();
    _y0 = 0.5 * verticalAnchor.getFactor() * (_scale * pHeight - height)
          + height + _scale * + paper.getMinY();
  }

  /** Transforms the device-independent x coordinate into Java coordinates. */
  public int transformX(double x) {
    return trim(_scale * x + _x0);
  }

  /** Transforms the device-independent y coordinate into Java coordinates. */
  public int transformY(double y) {
    return trim(_y0 - _scale * y);
  }

  /** Transforms the device-independent width into Java width. */
  public int transformWidth(double width) {
    return trim(_scale * width + 0.5);
  }

  /** Transforms the device-independent height into Java height. */
  public int transformHeight(double height) {
    return trim(_scale * height + 0.5);
  }
  
  private static int trim(double number)
  {
    return number > Short.MAX_VALUE 
              ? Short.MAX_VALUE 
              : (number < Short.MIN_VALUE ? Short.MIN_VALUE : (int) number); 
  }

  /**
   *  Transforms a point in Java coordinates back into device-independent
   *  coordinates.
   */
  public GraphPoint transformBack(int x, int y) {
    return new GraphPoint((x - _x0) / _scale, (_y0 - y) / _scale);
  }

public void apply(Graphics2D g) {
	g.translate(_x0, _y0);
	g.scale(_scale, -_scale);
	
}
}

