// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.transformation;

import jcckit.data.DataPoint;
import jcckit.graphic.GraphPoint;
import jcckit.util.Util;

/**
 *  Two-dimensional Cartesian transformation. The two independent
 *  transformations for the x-axis and the y-axis can be logarithmic
 *  from data coordinates to device-independent coordinates in order to
 *  realize diagrams with logarithmic scales.
 *
 *  @author Franz-Josef Elmer
 */
public class CartesianTransformation implements Transformation {
    // ::remove folder when __HAXE__
  private final boolean _xLogScale;
  private final double _xOffset;
  private final double _xScale;
  private final boolean _yLogScale;
  private final double _yOffset;
  private final double _yScale;

  /**
   *  Creates an instance from the specified reference points.
   *  Note, that the reference points must differ in x and y coordinates
   *  otherwise a transformation would not be possible.
   *  @param xLogScale <tt>true</tt> if logarithmic x axis.
   *  @param yLogScale <tt>true</tt> if logarithmic y axis.
   *  @param dataPoint1 First reference point in data coordinates.
   *  @param graphPoint1 First reference point in device-independent 
   *         coordinates.
   *  @param dataPoint2 Second reference point in data coordinates.
   *  @param graphPoint2 Second reference point in device-independent
   *         coordinates.
   *  @throws IllegalArgumentException if transformation in at least
   *          one of both directions is not possible.
   */
  public CartesianTransformation(boolean xLogScale, boolean yLogScale,
                           DataPoint dataPoint1, GraphPoint graphPoint1,
                           DataPoint dataPoint2, GraphPoint graphPoint2) {
    _xLogScale = xLogScale;
    double d1 = Util.log(dataPoint1.getX(), xLogScale);
    double dd = Util.log(dataPoint2.getX(), xLogScale) - d1;
    check(dd, "data", "x", d1);
    _xScale = (graphPoint2.getX() - graphPoint1.getX()) / dd;
    check(_xScale, "graphical", "x", graphPoint1.getX());
    _xOffset = graphPoint1.getX() - d1 * _xScale;

    _yLogScale = yLogScale;
    d1 = Util.log(dataPoint1.getY(), yLogScale);
    dd = Util.log(dataPoint2.getY(), yLogScale) - d1;
    check(dd, "data", "y", d1);
    _yScale = (graphPoint2.getY() - graphPoint1.getY()) / dd;
    check(_yScale, "graphical", "y", graphPoint1.getY());
    _yOffset = graphPoint1.getY() - d1 * _yScale;
  }

  private void check(double valueToCheck, String type, String axis,
                     double value) {
    if (valueToCheck == 0) {
      throw new IllegalArgumentException("The " + type
          + " reference points in " + axis + " must be different; both are "
          + value);
    }
  }

  public GraphPoint transformToGraph(DataPoint point) {
    return new GraphPoint(
        _xOffset + Util.log(point.getX(), _xLogScale) * _xScale,
        _yOffset + Util.log(point.getY(), _yLogScale) * _yScale);
  }

  public DataPoint transformToData(GraphPoint point) {
    return new DataPoint(
        Util.exp((point.getX() - _xOffset) / _xScale, _xLogScale),
        Util.exp((point.getY() - _yOffset) / _yScale, _yLogScale));
  }
}
