// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.util;

import java.awt.Color;
import java.util.StringTokenizer;

import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;


/**
 *  Read-only class for hierarchically organized key-value pairs.
 *  The key is always a string. The following value types are
 *  supported:
 *  <ul><li><tt>String</tt>
 *      <li><tt>boolean</tt>
 *      <li><tt>int</tt>
 *      <li><tt>double</tt>
 *      <li><tt>double[]</tt>
 *      <li><tt>Color</tt>
 *      <li><tt>ConfigParameters</tt>
 *  </ul>
 *  <p>
 *  In accordance with the Strategy design pattern the retrieval of
 *  a key-value pair is delegated to an instance of
 *  {@link ConfigData}.
 *
 *  @author Franz-Josef Elmer
 */
public class ConfigParameters {
  private final ConfigData _configData;

  /** Creates an instance from the specified <tt>ConfigData</tt> object. */
  public ConfigParameters(ConfigData configData) {
    _configData = configData;
  }

  /**
   * Returns the full key.
   * @return the path concatenated with <tt>key</tt>.
   * @see ConfigData#getFullKey
   */
  public String getFullKey(String key) {
    return _configData.getFullKey(key);
  }

  /**
   * Returns the string value associated with the specified key.
   * @param key The (relative) key. <tt>null</tt> is not allowed.
   * @return the corresponding value. Will always be not <tt>null</tt>.
   * @throws IllegalArgumentException if no value exists for <tt>key</tt>.
   *         The exception message is the full key.
   */
  public String get(String key) {
    String result = _configData.get(key);
    if (result == null) {
      throw new IllegalArgumentException(getFullKey(key));
    }
    return result;
  }

  /**
   * Returns the string value associated with the specified key or
   * <tt>defaultValue</tt> if undefined.
   * @param key The (relative) key. <tt>null</tt> is not allowed.
   * @param defaultValue The default value. Can be <tt>null</tt>.
   * @return the corresponding value or <tt>defaultValue</tt>.
   */
  public String get(String key, String defaultValue) {
    String result = _configData.get(key);
    if (result == null) {
      result = defaultValue;
    }
    return result;
  }

  /**
   * Returns the boolean associated with the specified key.
   * @param key The (relative) key. <tt>null</tt> is not allowed.
   * @return <tt>true</tt> if the value is "true" otherwise <tt>false</tt>.
   * @throws IllegalArgumentException if no value exists for <tt>key</tt>.
   *         The exception message is the full key.
   * @throws NumberFormatException if the value is neither "true" nor "false".
   */
  public boolean getBoolean(String key) {
    return parseBoolean(get(key), key);
  }

  /**
   * Returns the boolean associated with the specified key.
   * @param key The (relative) key. <tt>null</tt> is not allowed.
   * @param defaultValue The default value. Can be <tt>null</tt>.
   * @return <tt>true</tt> if the value is "true" otherwise <tt>false</tt>.
   * @throws NumberFormatException if the value is neither "true" nor "false".
   */
  public boolean getBoolean(String key, boolean defaultValue) {
    String value = _configData.get(key);
    return value == null ? defaultValue : parseBoolean(value, key);
  }

  private boolean parseBoolean(String value, String key) {
    if (value.equals("true")) {
      return true;
    } else if (value.equals("false")) {
      return false;
    } else {
      throw createNumberFormatException("boolean", value, key);
    }
  }

  private NumberFormatException createNumberFormatException(String text,
                                                            String value,
                                                            String key) {
    return new NumberFormatException("Not a " + text + ": " + getFullKey(key)
                                     + " = " + value);
  }

  /**
   * Returns the integer associated with the specified key.
   * The value can be either
   * <ul><li>a decimal number (starting with a non-zero digit),
   *     <li>a hexadecimal number (starting with <tt>0x</tt>), or
   *     <li>an octal number (starting with zero).
   * </ul>
   * @param key The (relative) key. <tt>null</tt> is not allowed.
   * @return the integer value.
   * @throws IllegalArgumentException if no value exists for <tt>key</tt>.
   *         The exception message is the full key.
   * @throws NumberFormatException if the value is not a number.
   *         The exception message contains the full key and the invalid value.
   */
  public int getInt(String key) {
    return parseInt(get(key), key);
  }

  /**
   * Returns the integer associated with the specified key or
   * <tt>defaultValue</tt> if no key-value pair exists for the specified key.
   * The value can be either
   * <ul><li>a decimal number (starting with a non-zero digit),
   *     <li>a hexadecimal number (starting with <tt>0x</tt>), or
   *     <li>an octal number (starting with zero).
   * </ul>
   * @param key The (relative) key. <tt>null</tt> is not allowed.
   * @param defaultValue The default value. Can be <tt>null</tt>.
   * @return the integer value.
   * @throws NumberFormatException if the value exists but is not a number.
   *         The exception message contains the full key and the invalid value.
   */
  public int getInt(String key, int defaultValue) {
    String value = _configData.get(key);
    return value == null ? defaultValue : parseInt(value, key);
  }

  private int parseInt(String value, String key) {
    try {
      return Integer.decode(value).intValue();
    } catch (NumberFormatException e) {
      throw createNumberFormatException("number", value, key);
    }
  }

  /**
   * Returns the double associated with the specified key.
   * @param key The (relative) key. <tt>null</tt> is not allowed.
   * @return the double value.
   * @throws IllegalArgumentException if no value exists for <tt>key</tt>.
   *         The exception message is the full key.
   * @throws NumberFormatException if the value is not a valid number.
   *         The exception message contains the full key and the invalid value.
   */
  public double getDouble(String key) {
    return parseDouble(get(key), key);
  }

  /**
   * Returns the double associated with the specified key or
   * <tt>defaultValue</tt> if no key-value pair exists for the specified key.
   * @param key The (relative) key. <tt>null</tt> is not allowed.
   * @param defaultValue The default value. Can be <tt>null</tt>.
   * @return the double value.
   * @throws NumberFormatException if the value exists but is not a valid
   *         number.
   *         The exception message contains the full key and the invalid value.
   */
  public double getDouble(String key, double defaultValue) {
    String value = _configData.get(key);
    return value == null ? defaultValue : parseDouble(value, key);
  }

  private double parseDouble(String value, String key) {
    try {
      return Double.parseDouble(value);
    } catch (NumberFormatException e) {
      throw createNumberFormatException("number", value, key);
    }
  }

  /**
   * Returns the array of doubles associated with the specified key.
   * The numbers are separated by whitespaces.
   * @param key The (relative) key. <tt>null</tt> is not allowed.
   * @return the array of double values.
   * @throws IllegalArgumentException if no value exists for <tt>key</tt>.
   *         The exception message is the full key.
   * @throws NumberFormatException if the value exists but is not a
   *         sequence of number. The exception message contains
   *         the full key and the invalid value.
   */
  public double[] getDoubleArray(String key) {
    return parseDoubleArray(get(key), key);
  }

  /**
   * Returns the array of doubles associated with the specified key
   * or <tt>defaultValue</tt> if no key-value pair exists for
   * the specified key. The numbers are separated by whitespaces.
   * @param key The (relative) key. <tt>null</tt> is not allowed.
   * @param defaultValue The default value. Can be <tt>null</tt>.
   * @return the array of double values.
   * @throws NumberFormatException if the value exists but is not a
   *         sequence of number. The exception message contains
   *         the full key and the invalid value.
   */
  public double[] getDoubleArray(String key, double[] defaultValue) {
    String value = _configData.get(key);
    return value == null ? defaultValue : parseDoubleArray(value, key);
  }

  private double[] parseDoubleArray(String value, String key) {
    try {
      StringTokenizer tokenizer = new StringTokenizer(value);
      double[] result = new double[tokenizer.countTokens()];
      for (int i = 0; i < result.length; i++) {
        result[i] = Double.parseDouble(tokenizer.nextToken());
      }
      return result;
    } catch (NumberFormatException e) {
      throw createNumberFormatException("sequence of numbers", value, key);
    }
  }

  /**
   * Returns the color associated with the specified key.
   * The color is coded as
   * <ul><li>a decimal number (starting with a non-zero digit),
   *     <li>a hexadecimal number (starting with <tt>0x</tt>), or
   *     <li>an octal number (starting with zero).
   * </ul>
   * @param key The (relative) key. <tt>null</tt> is not allowed.
   * @return the color.
   * @throws NumberFormatException if the value exists but is not a number.
   *         The exception message contains the full key and the invalid value.
   */
  public Color getColor(String key) {
    return parseColor(get(key), key);
  }

  /**
   * Returns the color associated with the specified key or the specified
   * default value if no key-value pair exists for the specified key.
   * The color is coded as
   * <ul><li>a decimal number (starting with a non-zero digit),
   *     <li>a hexadecimal number (starting with <tt>0x</tt>), or
   *     <li>an octal number (starting with zero).
   * </ul>
   * @param key The (relative) key. <tt>null</tt> is not allowed.
   * @param defaultValue The default value. Can be <tt>null</tt>.
   * @return the color or <tt>null</tt> if the value is an empty string.
   * @throws NumberFormatException if the value exists but is not a number.
   *         The exception message contains the full key and the invalid value.
   */
  public Color getColor(String key, Color defaultValue) {
    String value = _configData.get(key);
    return value == null ? defaultValue : parseColor(value, key);
  }

  private Color parseColor(String value, String key) {
    try {
      return value.length() == 0 ? null : decodeInternal(value);
    } catch (NumberFormatException e) {
      throw createNumberFormatException("number", value, key);
    }
  }

static private HColorSet colors = HColorSet.instance();
private Color decodeInternal(String value) {
	if (value!=null) {
		  try {
			return colors.getColor(value).toColor(ColorMapper.IDENTITY);
		} catch (NoSuchColorException e) {
			return Color.WHITE;
		}
	}
	return Color.decode(value);
}

  /**
   * Returns the child node associated with the specified key.
   * This method returns in any case a non-<tt>null</tt> result.
   * @param key The (relative) key. <tt>null</tt> is not allowed.
   * @return the corresponding child node which may be empty.
   */
  public ConfigParameters getNode(String key) {
    return new ConfigParameters(_configData.getNode(key));
  }
}
