// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package jcckit.util;

import java.lang.reflect.Constructor;

/**
 *  General purpose factory method based on {@link ConfigParameters}
 *  and Java's Reflection API.
 *
 *  @author Franz-Josef Elmer
 */
public class Factory {
  /** The constant defining the key <tt>className</tt>. */
  public static final String CLASS_NAME_KEY = "className";

  /** No public constructor necessary. */
  private Factory() {}
  
  /**
   * Creates an instance of the specified class.
   * @param className Fully-qualified name of a class with a default 
   *        constructor.
   * @return a new instance.
   * @throws IllegalArgumentException if the instance could be created.
   */
  public static Object create(String className) {
    try {
      return Class.forName(className).newInstance();
    } catch (Throwable t) {
      throw new IllegalArgumentException("Could not create an instance of " 
                                         + className + " because of " + t);
    }
  }

  /**
   *  Creates an object based on the specified configuration
   *  parameters. The class of the object is determined by the
   *  parameter with the key {@link #CLASS_NAME_KEY}.
   *  The constructor with a single argument of the type
   *  <tt>ConfigParameter</tt> is invoked with the argument 
   *  <tt>configParameters</tt>. If such a constructor
   *  does not exists the default constructor is invoked. If
   *  neither of these constructors exist a {@link FactoryException}
   *  is thrown.
   *  @param configParameters Configuration parameters.
   *  @return the newly created object.
   *  @throws IllegalArgumentException if key <tt>className</tt> is missing.
   *  @throws FactoryException wrapping any kind of exception or error occured.
   */
  public static Object create(ConfigParameters configParameters) {
    String className = configParameters.get(CLASS_NAME_KEY);
    return createObject(configParameters, className);
  }

  /**
   *  Creates an object based on the specified configuration
   *  parameters and default class name. If the
   *  parameter with the key {@link #CLASS_NAME_KEY} is missed in
   *  <tt>configParameters</tt> <tt>defaultClassName</tt> is used.
   *  Otherwise it works as {@link #create(jcckit.util.ConfigParameters)}.
   *  @param configParameters Configuration parameters.
   *  @param defaultClassName Default class name.
   *  @return the newly created object.
   *  @throws FactoryException wrapping any kind of exception or error occured.
   */
  public static Object create(ConfigParameters configParameters,
                              String defaultClassName) {
    String className = configParameters.get(CLASS_NAME_KEY, defaultClassName);
    return createObject(configParameters, className);
  }

  /**
   *  Creates an object based on the specified configuration
   *  parameters or returns the default object. This method behaves
   *  as {@link #create(jcckit.util.ConfigParameters)}, except that is does 
   *  not throw an <tt>IllegalArgumentException</tt> if key <tt>className</tt>
   *  is missing. Instead <tt>defaultObject</tt> is returned.
   */
  public static Object createOrGet(ConfigParameters configParameters,
                                   Object defaultObject) {
    String className = configParameters.get(CLASS_NAME_KEY, null);
    return className == null ? defaultObject
                             : createObject(configParameters, className);
  }

  private static Object createObject(ConfigParameters configParameters,
                                     String className) {
    try {
      Class c = Class.forName(className);
      Object result = null;
      Constructor constructor = null;
      try {
        constructor = c.getConstructor(new Class[] {ConfigParameters.class});
        result = constructor.newInstance(new Object[] {configParameters});
      } catch (NoSuchMethodException e) {
        result = c.newInstance();
      }
      return result;
    } catch (Throwable t) {
      throw new FactoryException(configParameters, CLASS_NAME_KEY, t);
    }
  }
}
