// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.acearth;

import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

import zext.plantuml.com.ctreber.acearth.ACearth;
import zext.plantuml.com.ctreber.acearth.ConfigurationACearth;
import zext.plantuml.com.ctreber.acearth.plugins.markers.Marker;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;

public class PSystemXearth extends AbstractPSystem {
	// ::remove folder when __CORE__
	// ::remove folder when __MIT__ or __EPL__ or __BSD__ or __ASL__ or __LGPL__

	final private int width;
	final private int height;
	final private Map<String, String> config;
	final private List<Marker> markers;

	final private Collection<String> enums = Arrays.asList("viewPositionType");
	final private Collection<String> doubles = Arrays.asList("sunPosRelLat", "sunPosRelLong", "orbitPeriod",
			"orbitInclination", "viewPosLat", "viewPosLong", "starFrequency", "viewMagnification");
	final private Collection<String> integers = Arrays.asList("daySideBrightness", "nightSideBrightness",
			"terminatorDiscontinuity", "gridDivision", "gridPixelDivision", "bigStars");
	final private Collection<String> booleans = Arrays.asList("shadeP", "gridP", "starsP");

	public PSystemXearth(UmlSource source, int width, int height, Map<String, String> config, List<Marker> markers) {
		super(source);
		this.width = width;
		this.height = height;
		this.config = config;
		this.markers = markers;
	}

	@Override
	final protected ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat)
			throws IOException {
		synchronized (PSystemXearth.class) {
			final ACearth earth = new ACearth(markers);
			final ConfigurationACearth conf = earth.getConf();
			conf.setInt("imageWidth", width);
			conf.setInt("imageHeight", height);

			for (Map.Entry<String, String> ent : config.entrySet()) {
				final String key = ent.getKey();
				final String value = ent.getValue();
				if (key.equalsIgnoreCase("GMT")) {
					final Date date = extractGmt(value);
					conf.setInt("fixedTime", (int) (date.getTime() / 1000L));
				} else if (enums.contains(key)) {
					conf.getMOEnum(key).set(value);
				} else if (doubles.contains(key)) {
					conf.setDouble(key, Double.parseDouble(value));
				} else if (integers.contains(key)) {
					conf.setInt(key, Integer.parseInt(value));
				} else if (booleans.contains(key)) {
					conf.setBoolean(key, value.equalsIgnoreCase("true"));
				} else {
					throw new UnsupportedOperationException(key);
				}
			}
			earth.exportPng(os);
			return new ImageDataSimple(width, height);
		}
	}

	private Date extractGmt(String s) {
		final SimpleDateFormat timeFormat;
		if (s.matches("\\d{4}/\\d{2}/\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
			timeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.US);
		} else if (s.matches("\\d{4}/\\d{2}/\\d{2} \\d{2}:\\d{2}")) {
			timeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm", Locale.US);
		} else {
			throw new UnsupportedOperationException(s);
		}
		timeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
		try {
			return timeFormat.parse(s);
		} catch (ParseException e) {
			throw new UnsupportedOperationException(s);
		}

	}

	public DiagramDescription getDescription() {
		return new DiagramDescription("(XEarth)");
	}

}
