// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.api;

import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.prefs.Preferences;

import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.utils.Log;

public class NumberAnalyzed2 implements INumberAnalyzed {
    // ::remove folder when __HAXE__

	private static final int SLIDING_WINDOW = 512;

	private final AtomicLong nb = new AtomicLong();
	private final AtomicLong sum = new AtomicLong();
	private final AtomicLong min = new AtomicLong();
	private final AtomicLong max = new AtomicLong();
	private final AtomicLong sumOfSquare = new AtomicLong();
	// See https://fossies.org/linux/haproxy/include/proto/freq_ctr.h
	private final AtomicLong sliddingSum = new AtomicLong();
	private final String name;

	public NumberAnalyzed2(String name) {
		this.name = name;
	}

	public void reset() {
		this.nb.set(0);
		this.sum.set(0);
		this.min.set(0);
		this.max.set(0);
		this.sumOfSquare.set(0);
		this.sliddingSum.set(0);
	}

	public NumberAnalyzed2() {
		this("");
	}

	public final void save(Preferences prefs) {
		if (name.length() == 0) {
			throw new UnsupportedOperationException();
		}
		prefs.put(name + ".saved", getSavedString());
	}

	protected String getSavedString() {
		final String value = longToString(nb) + ";" + longToString(sum) + ";" + longToString(min) + ";"
				+ longToString(max) + ";" + longToString(sumOfSquare) + ";" + longToString(sliddingSum);
		return value;
	}

	protected final String longToString(AtomicLong val) {
		return Long.toString(val.get(), 36);
	}

	public static NumberAnalyzed2 load(String name, Preferences prefs) {
		final String value = prefs.get(name + ".saved", "");
		if (value.length() == 0) {
			System.err.println("Cannot load " + name);
			return null;
		}
		try {
			final StringTokenizer st = new StringTokenizer(value, ";");
			return new NumberAnalyzed2(name, Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36),
					Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36),
					Long.parseLong(st.nextToken(), 36), Long.parseLong(st.nextToken(), 36));
		} catch (Exception e) {
			Logme.error(e);
			Log.info("Error reading " + value);
			return null;
		}
	}

	@Override
	public String toString() {
		return "sum=" + sum + " nb=" + nb + " min=" + min + " max=" + max + " mean=" + getMean();
	}

	protected NumberAnalyzed2(String name, long nb, long sum, long min, long max, long sumOfSquare, long sliddingSum) {
		this(name);
		this.nb.set(nb);
		this.sum.set(sum);
		this.min.set(min);
		this.max.set(max);
		this.sumOfSquare.set(sumOfSquare);
		this.sliddingSum.set(sliddingSum);
	}

	public INumberAnalyzed getCopyImmutable() {
		final NumberAnalyzed2 copy = new NumberAnalyzed2(name, nb.get(), sum.get(), min.get(), max.get(),
				sumOfSquare.get(), sliddingSum.get());
		return copy;
	}

	public void addValue(long v) {
		nb.incrementAndGet();
		if (nb.get() == 1) {
			min.set(v);
			max.set(v);
		} else if (v > max.get()) {
			max.set(v);
		} else if (v < min.get()) {
			min.set(v);
		}
		sum.addAndGet(v);
		sumOfSquare.addAndGet(v * v);
		sliddingSum.set(sliddingSum.get() * (SLIDING_WINDOW - 1) / SLIDING_WINDOW + v);
	}

	public void add(NumberAnalyzed2 other) {
		this.sum.addAndGet(other.sum.get());
		this.nb.addAndGet(other.nb.get());
		this.min.set(Math.min(this.min.get(), other.min.get()));
		this.max.set(Math.max(this.max.get(), other.max.get()));
	}

	public final long getNb() {
		return nb.get();
	}

	public final long getSum() {
		return sum.get();
	}

	public final long getMin() {
		return min.get();
	}

	public final long getMax() {
		return max.get();
	}

	public final long getMean() {
		if (nb.get() == 0) {
			return 0;
		}
		// Bad
		return sum.get() / nb.get();
	}

	public final long getSliddingMean() {
		if (nb.get() == 0) {
			return 0;
		}
		if (nb.get() < SLIDING_WINDOW) {
			return sum.get() / nb.get();
		}
		// Bad
		return sliddingSum.get() / nb.get();
	}

	final public String getName() {
		return name;
	}

}
