// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.asciiart;

public enum AsciiShape {

	// int STICKMAN_HEIGHT = 5;
	// int STICKMAN_UNICODE_HEIGHT = 6;

	STICKMAN(3, 5), STICKMAN_UNICODE(3, 6), BOUNDARY(8, 3), DATABASE(10, 6);

	private final int width;
	private final int height;

	private AsciiShape(int width, int height) {
		this.width = width;
		this.height = height;
	}

	public void draw(BasicCharArea area, int x, int y) {
		if (this == STICKMAN) {
			drawStickMan(area, x, y);
		} else if (this == STICKMAN_UNICODE) {
			drawStickManUnicode(area, x, y);
		} else if (this == BOUNDARY) {
			drawBoundary(area, x, y);
		} else if (this == DATABASE) {
			drawDatabase(area, x, y);
		}
	}

	private void drawDatabase(BasicCharArea area, int x, int y) {
		area.drawStringLR(" ,.-^^-._", x, y++);
		area.drawStringLR("|-.____.-|", x, y++);
		area.drawStringLR("|        |", x, y++);
		area.drawStringLR("|        |", x, y++);
		area.drawStringLR("|        |", x, y++);
		area.drawStringLR("'-.____.-'", x, y++);
	}

	private void drawDatabaseSmall(BasicCharArea area, int x, int y) {
		area.drawStringLR(" ,.-\"-._ ", x, y++);
		area.drawStringLR("|-.___.-|", x, y++);
		area.drawStringLR("|       |", x, y++);
		area.drawStringLR("|       |", x, y++);
		area.drawStringLR("|       |", x, y++);
		area.drawStringLR("'-.___.-'", x, y++);
	}

	private void drawBoundary(BasicCharArea area, int x, int y) {
		area.drawStringLR("|   ,-.", x, y++);
		area.drawStringLR("+--{   )", x, y++);
		area.drawStringLR("|   `-'", x, y++);
	}

	private void drawStickMan(BasicCharArea area, int x, int y) {
		area.drawStringLR(",-.", x, y++);
		area.drawStringLR("`-'", x, y++);
		area.drawStringLR("/|\\", x, y++);
		area.drawStringLR(" | ", x, y++);
		area.drawStringLR("/ \\", x, y++);
	}

	private void drawStickManUnicode(BasicCharArea area, int x, int y) {
		area.drawStringLR("\u250c\u2500\u2510", x, y++);
		area.drawStringLR("\u2551\"\u2502", x, y++);
		area.drawStringLR("\u2514\u252c\u2518", x, y++);
		area.drawStringLR("\u250c\u253c\u2510", x, y++);
		area.drawStringLR(" \u2502 ", x, y++);
		area.drawStringLR("\u250c\u2534\u2510", x, y++);
	}

	public final int getHeight() {
		return height;
	}

	public final int getWidth() {
		return width;
	}

}
