// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.asciiart;

import java.io.PrintStream;
import java.util.Collection;
import java.util.List;

public class TranslatedCharArea implements UmlCharArea {
    // ::remove folder when __HAXE__

	private final int dx;
	private final int dy;
	private final UmlCharArea charArea;

	public TranslatedCharArea(UmlCharArea charArea, int dx, int dy) {
		this.charArea = charArea;
		this.dx = dx;
		this.dy = dy;
	}

	public void drawBoxSimple(int x, int y, int width, int height) {
		charArea.drawBoxSimple(x + dx, y + dy, width, height);

	}

	public void drawBoxSimpleUnicode(int x, int y, int width, int height) {
		charArea.drawBoxSimpleUnicode(x + dx, y + dy, width, height);
	}

	public void drawNoteSimple(int x, int y, int width, int height) {
		charArea.drawNoteSimple(x + dx, y + dy, width, height);
	}

	public void drawNoteSimpleUnicode(int x, int y, int width, int height) {
		charArea.drawNoteSimpleUnicode(x + dx, y + dy, width, height);
	}

	public void drawShape(AsciiShape shape, int x, int y) {
		charArea.drawShape(shape, x + dx, y + dy);
	}

	public void drawChar(char c, int x, int y) {
		charArea.drawChar(c, x + dx, y + dy);
	}

	public void drawHLine(char c, int line, int col1, int col2) {
		charArea.drawHLine(c, line + dy, col1 + dx, col2 + dx);
	}

	public void drawHLine(char c, int line, int col1, int col2, char ifFound, char thenUse) {
		charArea.drawHLine(c, line + dy, col1 + dx, col2 + dx, ifFound, thenUse);
	}

	public void drawStringLR(String string, int x, int y) {
		charArea.drawStringLR(string, x + dx, y + dy);
	}

	public void drawStringTB(String string, int x, int y) {
		charArea.drawStringTB(string, x + dx, y + dy);
	}

	public void drawVLine(char c, int col, int line1, int line2) {
		charArea.drawVLine(c, col + dx, line1 + dy, line2 + dy);
	}

	public int getHeight() {
		return charArea.getHeight();
	}

	public int getWidth() {
		return charArea.getWidth();
	}

	public String getLine(int line) {
		return charArea.getLine(line);
	}

	public List<String> getLines() {
		return charArea.getLines();
	}

	public void print(PrintStream ps) {
		charArea.print(ps);
	}

	public void drawStringsLRSimple(Collection<? extends CharSequence> strings, int x, int y) {
		charArea.drawStringsLRSimple(strings, x + dx, y + dy);
	}

	public void drawStringsLRUnicode(Collection<? extends CharSequence> strings, int x, int y) {
		charArea.drawStringsLRUnicode(strings, x + dx, y + dy);
	}

	public void fillRect(char c, int x, int y, int width, int height) {
		charArea.fillRect(c, x + dx, y + dy, width, height);
	}

}
