// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.board;

import java.util.concurrent.atomic.AtomicInteger;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.style.ISkinParam;

public class Activity {

	private final BNode node;
	private final ISkinParam skinParam;
	private BNode cursor;

	private final BoardDiagram boardDiagram;

	public Activity(BoardDiagram boardDiagram, String name, ISkinParam skinParam) {
		this.boardDiagram = boardDiagram;
		this.node = new BNode(0, name);
		this.skinParam = skinParam;
		this.cursor = this.node;
	}

	public TextBlock getBox() {
		return new CardBox(Display.create(node.getName()), skinParam);
	}

	public void addRelease(int stage, String label) {
		if (stage <= 0) {
			throw new IllegalArgumentException();
		}
		final BNode newNode = new BNode(stage, label);
		while (true) {
			if (stage > cursor.getStage()) {
				cursor.addChild(newNode);
				cursor = newNode;
				return;
			}
			cursor = cursor.getParent();
		}
	}

	private BArray array;

	private BArray getArray() {
		if (array == null) {
			node.computeX(new AtomicInteger());
			array = new BArray();
			node.initBarray(array);
		}
		return array;
	}

	public double getFullWidth() {
		final BArray array = getArray();
		return (array.getMaxX() + 1) * PostIt.getWidth();
	}

	public int getMaxStage() {
		final BArray array = getArray();
		return array.getMaxY();
	}

	public void drawMe(UGraphic ug) {

		getBox().drawU(ug);

		final BArray array = getArray();

		for (BNode node : array) {
			final double dx = node.getX() * PostIt.getWidth();
			final double dy = node.getStage() * PostIt.getHeight();
			ug.apply(new UTranslate(dx, dy));

			CardBox box = new CardBox(Display.create(node.getName()), skinParam);
			box.drawU(ug.apply(new UTranslate(dx, dy)));

		}

//		for (Entry<Integer, List<PostIt>> ent : postits.entrySet()) {
//			final int line = ent.getKey();
//			final List<PostIt> list = ent.getValue();
//			double dy = boardDiagram.getStageY(ug.getStringBounder(), line);
//			for (PostIt postit : list) {
//				postit.getCard().drawU(ug.apply(UTranslate.dy(dy)));
//				dy += PostIt.getHeight(ug.getStringBounder());
//			}
//
//		}

	}

}
