// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.braille;

public class BrailleChar {
	// ::remove folder when __CORE__

	private final int id;

	private BrailleChar(int id) {
		this.id = id;
	}

	public void draw(BrailleGrid grid, double xv, double yv) {
		final int x = grid.toInt(xv);
		final int y = grid.toInt(yv);
		drawOneSpot(grid, x + 0, y + 0, 1);
		drawOneSpot(grid, x + 0, y + 1, 2);
		drawOneSpot(grid, x + 0, y + 2, 4);
		drawOneSpot(grid, x + 1, y + 0, 8);
		drawOneSpot(grid, x + 1, y + 1, 16);
		drawOneSpot(grid, x + 1, y + 2, 32);
	}

	private void drawOneSpot(BrailleGrid grid, int x, int y, int check) {
		if ((id & check) != 0) {
			grid.setState(x, y, true);
		}

	}

	public static BrailleChar fromChar(char c) {
		if (c == 'a' || c == 'A' || c == '1') {
			return new BrailleChar(1);
		}
		if (c == 'b' || c == 'B' || c == '2') {
			return new BrailleChar(1 + 2);
		}
		if (c == 'c' || c == 'C' || c == '3') {
			return new BrailleChar(1 + 8);
		}
		if (c == 'd' || c == 'D' || c == '4') {
			return new BrailleChar(1 + 8 + 16);
		}
		if (c == 'e' || c == 'E' || c == '5') {
			return new BrailleChar(1 + 16);
		}
		if (c == 'f' || c == 'F' || c == '6') {
			return new BrailleChar(1 + 8 + 2);
		}
		if (c == 'g' || c == 'G' || c == '7') {
			return new BrailleChar(1 + 2 + 8 + 16);
		}
		if (c == 'h' || c == 'H' || c == '8') {
			return new BrailleChar(1 + 2 + 16);
		}
		if (c == 'i' || c == 'I' || c == '9') {
			return new BrailleChar(2 + 8);
		}
		if (c == 'j' || c == 'J' || c == '0') {
			return new BrailleChar(2 + 8 + 16);
		}
		if (c == 'k' || c == 'K') {
			return new BrailleChar(1 + 4);
		}
		if (c == 'l' || c == 'L') {
			return new BrailleChar(1 + 2 + 4);
		}
		if (c == 'm' || c == 'M') {
			return new BrailleChar(1 + 4 + 8);
		}
		if (c == 'n' || c == 'N') {
			return new BrailleChar(1 + 4 + 8 + 16);
		}
		if (c == 'o' || c == 'O') {
			return new BrailleChar(1 + 4 + 16);
		}
		if (c == 'p' || c == 'P') {
			return new BrailleChar(1 + 2 + 4 + 8);
		}
		if (c == 'q' || c == 'Q') {
			return new BrailleChar(1 + 2 + 4 + 8 + 16);
		}
		if (c == 'r' || c == 'R') {
			return new BrailleChar(1 + 2 + 4 + 16);
		}
		if (c == 's' || c == 'S') {
			return new BrailleChar(2 + 4 + 8);
		}
		if (c == 't' || c == 'T') {
			return new BrailleChar(2 + 4 + 8 + 16);
		}
		if (c == 'u' || c == 'U') {
			return new BrailleChar(1 + 4 + 32);
		}
		if (c == 'v' || c == 'V') {
			return new BrailleChar(1 + 2 + 4 + 32);
		}
		if (c == 'w' || c == 'W') {
			return new BrailleChar(2 + 8 + 16 + 32);
		}
		if (c == 'x' || c == 'X') {
			return new BrailleChar(1 + 4 + 8 + 32);
		}
		if (c == 'y' || c == 'Y') {
			return new BrailleChar(1 + 4 + 8 + 16 + 32);
		}
		if (c == 'z' || c == 'Z') {
			return new BrailleChar(1 + 4 + 16 + 32);
		}
		if (c == ' ') {
			return new BrailleChar(0);
		}
		if (c == '\'') {
			return new BrailleChar(2);
		}
		if (c == ';') {
			return new BrailleChar(2 + 4);
		}
		if (c == ':') {
			return new BrailleChar(2 + 16);
		}
		if (c == '!') {
			return new BrailleChar(2 + 4 + 16);
		}
		if (c == '(' || c == ')') {
			return new BrailleChar(2 + 4 + 16 + 32);
		}
		if (c == '?' || c == '.' || c == '\"') {
			return new BrailleChar(2 + 4 + 32);
		}
		if (c == ',') {
			return new BrailleChar(4);
		}
		if (c == '-') {
			return new BrailleChar(4 + 32);
		}
		return new BrailleChar(63);
	}

}
