// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.Parser;
import net.sourceforge.plantuml.klimt.creole.legacy.CreoleParser;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockLineBefore;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.url.UrlBuilder;

public class BodierLikeClassOrObject implements Bodier {

	private final List<CharSequence> rawBody = new ArrayList<>();
	private final Set<VisibilityModifier> hides;
	private LeafType type;
	private List<Member> methodsToDisplay;
	private List<Member> fieldsToDisplay;
	private Entity leaf;

	@Override
	public void muteClassToObject() {
		methodsToDisplay = null;
		fieldsToDisplay = null;
		type = LeafType.OBJECT;
	}

	BodierLikeClassOrObject(LeafType type, Set<VisibilityModifier> hides) {
		if (type == LeafType.MAP)
			throw new IllegalArgumentException();

		this.type = Objects.requireNonNull(type);
		assert type.isLikeClass() || type == LeafType.OBJECT;
		this.hides = hides;
	}

	@Override
	public void setLeaf(Entity leaf) {
		this.leaf = Objects.requireNonNull(leaf);

	}

	@Override
	public boolean addFieldOrMethod(String s) {
		// Empty cache
		methodsToDisplay = null;
		fieldsToDisplay = null;
		rawBody.add(s);
		return true;
	}

	private boolean isBodyEnhanced() {
		for (CharSequence s : rawBody)
			if (BodyEnhanced1.isBlockSeparator(s) || CreoleParser.isTableLine(s.toString())
					|| Parser.isTreeStart(s.toString()))
				return true;

		return false;
	}

	private boolean isMethod(CharSequence s) {
		final String purged = s.toString().replaceAll(UrlBuilder.getRegexp(), "");
		if (purged.contains("{method}"))
			return true;

		if (purged.contains("{field}"))
			return false;

		return purged.contains("(") || purged.contains(")");
	}

	@Override
	public Display getMethodsToDisplay() {
		if (methodsToDisplay == null) {
			methodsToDisplay = new ArrayList<>();
			for (int i = 0; i < rawBody.size(); i++) {
				final CharSequence s = rawBody.get(i);
				if (isMethod(i, rawBody) == false)
					continue;

				if (s.length() == 0 && methodsToDisplay.size() == 0)
					continue;

				final Member m = Member.method(s);
				if (hides == null || hides.contains(m.getVisibilityModifier()) == false)
					methodsToDisplay.add(m);

			}
			removeFinalEmptyMembers(methodsToDisplay);
		}
		return Display.create(methodsToDisplay);
	}

	private boolean isMethod(int i, List<CharSequence> rawBody) {
		if (i > 0 && i < rawBody.size() - 1 && rawBody.get(i).length() == 0 && isMethod(rawBody.get(i - 1))
				&& isMethod(rawBody.get(i + 1))) {
			return true;
		}
		return isMethod(rawBody.get(i));
	}

	@Override
	public Display getFieldsToDisplay() {
		if (fieldsToDisplay == null) {
			fieldsToDisplay = new ArrayList<>();
			for (CharSequence s : rawBody) {
				if (type != LeafType.OBJECT && isMethod(s) == true)
					continue;

				if (s.length() == 0 && fieldsToDisplay.size() == 0)
					continue;

				final Member m = Member.field(s);
				if (hides == null || hides.contains(m.getVisibilityModifier()) == false)
					fieldsToDisplay.add(m);

			}
			removeFinalEmptyMembers(fieldsToDisplay);
		}
		return Display.create(fieldsToDisplay);
	}

	private void removeFinalEmptyMembers(List<Member> result) {
		while (result.size() > 0 && StringUtils.trin(result.get(result.size() - 1).getDisplay(false)).length() == 0)
			result.remove(result.size() - 1);

	}

	@Override
	public boolean hasUrl() {
		for (CharSequence cs : getFieldsToDisplay())
			if (cs instanceof Member) {
				final Member m = (Member) cs;
				if (m.hasUrl())
					return true;

			}

		for (CharSequence cs : getMethodsToDisplay())
			if (cs instanceof Member) {
				final Member m = (Member) cs;
				if (m.hasUrl())
					return true;

			}
		return false;
	}

	private List<CharSequence> rawBodyWithoutHidden() {
		final List<CharSequence> result = new ArrayList<>();
		for (CharSequence s : rawBody) {
			final Member m;
			if (isMethod(s))
				m = Member.method(s);
			else
				m = Member.field(s);

			if (hides.contains(m.getVisibilityModifier()) == false)
				result.add(m);

		}
		return result;
	}

	@Override
	public TextBlock getBody(ISkinParam skinParam, boolean showMethods, boolean showFields, Stereotype stereotype,
			Style style, FontConfiguration fontConfiguration) {

		if (BodyFactory.BODY3)
			return new Body3(rawBody, skinParam, stereotype, style);

		if (type.isLikeClass() && isBodyEnhanced()) {
			if (showMethods || showFields)
				return BodyFactory.create1(skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT),
						rawBodyWithoutHidden(), skinParam, stereotype, leaf, style);

			return null;
		}
		if (leaf == null)
			throw new IllegalStateException();

		if (type == LeafType.OBJECT) {
			if (showFields == false)
				// return new TextBlockLineBefore(style.value(PName.LineThickness).asDouble(),
				// TextBlockUtils.empty(0, 0));
				return TextBlockUtils.empty(0, 0);

			return BodyFactory.create1(skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT),
					rawBodyWithoutHidden(), skinParam, stereotype, leaf, style);
		}
		assert type.isLikeClass();

		final MethodsOrFieldsArea fields = new MethodsOrFieldsArea(getFieldsToDisplay(), skinParam, leaf, style);

		final MethodsOrFieldsArea methods = new MethodsOrFieldsArea(getMethodsToDisplay(), skinParam, leaf, style);
		if (showFields && showMethods == false)
			return fields.asBlockMemberImpl();
		else if (showMethods && showFields == false)
			return methods.asBlockMemberImpl();
		else if (showFields == false && showMethods == false)
			return TextBlockUtils.empty(0, 0);

		final TextBlock bb1 = fields.asBlockMemberImpl();
		final TextBlock bb2 = methods.asBlockMemberImpl();
		return TextBlockUtils.mergeTB(bb1, bb2, HorizontalAlignment.LEFT);
	}

	@Override
	public List<CharSequence> getRawBody() {
		return Collections.unmodifiableList(rawBody);
	}

}
