// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.klimt.drawing.eps;

import java.awt.Color;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;

import net.sourceforge.plantuml.klimt.ClipContainer;
import net.sourceforge.plantuml.klimt.UClip;
import net.sourceforge.plantuml.klimt.UParam;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UDriver;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontStyle;
import net.sourceforge.plantuml.klimt.font.UFontContext;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.shape.UText;

public class DriverTextEps implements UDriver<UText, EpsGraphics> {

	private final ClipContainer clipContainer;
	private final EpsStrategy strategy;

	public DriverTextEps(ClipContainer clipContainer, EpsStrategy strategy) {
		this.clipContainer = clipContainer;
		this.strategy = strategy;
	}

	public void draw(UText shape, double x, double y, ColorMapper mapper, UParam param, EpsGraphics eps) {
		final UClip clip = clipContainer.getClip();
		if (clip != null && clip.isInside(x, y) == false)
			return;

		final FontConfiguration fontConfiguration = shape.getFontConfiguration();
		if (fontConfiguration.getColor().isTransparent())
			return;

		if (strategy == EpsStrategy.WITH_MACRO_AND_TEXT) {
			drawAsText(shape, x, y, param, eps, mapper);
			return;
		}

		final TextLayout textLayout = UFontContext.EPS.createTextLayout(shape);

		MinMax dim = null;

		if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR)) {
			final Color extended = fontConfiguration.getExtendedColor().toColor(mapper);
			if (extended != null) {
				eps.setStrokeColor(extended);
				eps.setFillColor(extended);
				eps.setStrokeWidth(1, 0, 0);
				if (dim == null)
					dim = getMinMax(x, y, getOutline(textLayout).getPathIterator(null));

				eps.epsRectangle(dim.getMinX() - 1, dim.getMinY() - 1, dim.getWidth() + 2, dim.getHeight() + 2, 0, 0);
			}
		}

		eps.setStrokeColor(fontConfiguration.getColor().toColor(mapper));
		drawPathIterator(eps, x, y, getOutline(textLayout));

		if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
			final HColor extended = fontConfiguration.getExtendedColor();
			if (extended != null)
				eps.setStrokeColor(extended.toColor(mapper));

			if (dim == null)
				dim = getMinMax(x, y, getOutline(textLayout).getPathIterator(null));

			eps.setStrokeWidth(1.1, 0, 0);
			eps.epsLine(x, y + 1.5, x + dim.getWidth(), y + 1.5);
			eps.setStrokeWidth(1, 0, 0);
		}
		if (fontConfiguration.containsStyle(FontStyle.WAVE)) {
			if (dim == null)
				dim = getMinMax(x, y, getOutline(textLayout).getPathIterator(null));

			final int ypos = (int) (y + 2.5) - 1;
			final HColor extended = fontConfiguration.getExtendedColor();
			if (extended != null)
				eps.setStrokeColor(extended.toColor(mapper));

			eps.setStrokeWidth(1.1, 0, 0);
			for (int i = (int) x; i < x + dim.getWidth() - 5; i += 6) {
				eps.epsLine(i, ypos - 0, i + 3, ypos + 1);
				eps.epsLine(i + 3, ypos + 1, i + 6, ypos - 0);
			}
			eps.setStrokeWidth(1, 0, 0);
		}
		if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
			final HColor extended = fontConfiguration.getExtendedColor();
			if (extended != null)
				eps.setStrokeColor(extended.toColor(mapper));

			if (dim == null)
				dim = getMinMax(x, y, getOutline(textLayout).getPathIterator(null));

			// final FontMetrics fm = font.getFontMetrics();
			final double ypos = (dim.getMinY() + dim.getMaxY() * 2) / 3;
			eps.setStrokeWidth(1.3, 0, 0);
			eps.epsLine(x, ypos, x + dim.getWidth(), ypos);
			eps.setStrokeWidth(1, 0, 0);
		}

	}

	private Shape getOutline(final TextLayout textLayout) {
		return textLayout.getOutline(null);
	}

	private void drawAsText(UText shape, double x, double y, UParam param, EpsGraphics eps, ColorMapper mapper) {
		final FontConfiguration fontConfiguration = shape.getFontConfiguration();
		// final FontMetrics fm =
		// g2dummy.getFontMetrics(fontConfiguration.getFont().getFont());
		// final double ypos = y - fm.getDescent() + 0.5;
		final double ypos = y - 1;

		eps.setStrokeColor(fontConfiguration.getColor().toColor(mapper));
		((EpsGraphicsMacroAndText) eps).drawText(shape.getText(), fontConfiguration, x, ypos);

	}

	static void drawPathIterator(EpsGraphics eps, double x, double y, Shape shape) {
		final List<Integer> breaks = analyze(shape);
		if (breaks.size() == 0) {
			final PathIterator path = shape.getPathIterator(null);
			drawSingle(eps, x, y, path);
			return;
		}
		// System.err.println("breaks=" + breaks);
		final PathIterator path = new PathIteratorLimited(shape, 0, breaks.get(0));
		drawSingle(eps, x, y, path);
		for (int i = 0; i < breaks.size() - 1; i++) {
			final PathIterator path2 = new PathIteratorLimited(shape, breaks.get(i) + 1, breaks.get(i + 1));
			drawSingle(eps, x, y, path2);
		}
		final PathIterator path3 = new PathIteratorLimited(shape, breaks.get(breaks.size() - 1) + 1, Integer.MAX_VALUE);
		drawSingle(eps, x, y, path3);

	}

	private static void drawSingle(EpsGraphics eps, double x, double y, final PathIterator path) {
		eps.newpath();
		final double coord[] = new double[6];
		while (path.isDone() == false) {
			final int code = path.currentSegment(coord);
			if (code == PathIterator.SEG_MOVETO)
				eps.moveto(coord[0] + x, coord[1] + y);
			else if (code == PathIterator.SEG_LINETO)
				eps.lineto(coord[0] + x, coord[1] + y);
			else if (code == PathIterator.SEG_CLOSE)
				eps.closepath();
			else if (code == PathIterator.SEG_CUBICTO)
				eps.curveto(coord[0] + x, coord[1] + y, coord[2] + x, coord[3] + y, coord[4] + x, coord[5] + y);
			else if (code == PathIterator.SEG_QUADTO)
				eps.quadto(coord[0] + x, coord[1] + y, coord[2] + x, coord[3] + y);
			else
				throw new UnsupportedOperationException("code=" + code);

			path.next();
		}

		eps.fill(path.getWindingRule());
	}

	private static List<Integer> analyze(Shape shape) {
		int count = PathIteratorLimited.count(shape);
		final List<Integer> closings = getClosings(shape.getPathIterator(null));
		final List<Integer> result = new ArrayList<>();
		for (Integer cl : closings) {
			if (cl + 2 >= count)
				break;

			final PathIterator path1 = new PathIteratorLimited(shape, 0, cl);
			final PathIterator path2 = new PathIteratorLimited(shape, cl + 1, Integer.MAX_VALUE);
			final double max1 = getMinMax(0, 0, path1).getMaxX();
			final double min2 = getMinMax(0, 0, path2).getMinX();
			if (min2 > max1)
				result.add(cl);

		}
		return result;
	}

	private static List<Integer> getClosings(PathIterator path) {
		final List<Integer> result = new ArrayList<>();
		int current = 0;
		final double coord[] = new double[6];
		while (path.isDone() == false) {
			final int code = path.currentSegment(coord);
			if (code == PathIterator.SEG_CLOSE)
				result.add(current);

			current++;
			path.next();
		}
		return result;
	}

	static private MinMax getMinMax(double x, double y, PathIterator path) {

		MinMax result = MinMax.getEmpty(false);

		final double coord[] = new double[6];
		while (path.isDone() == false) {
			final int code = path.currentSegment(coord);
			if (code == PathIterator.SEG_MOVETO) {
				result = result.addPoint(coord[0] + x, coord[1] + y);
			} else if (code == PathIterator.SEG_LINETO) {
				result = result.addPoint(coord[0] + x, coord[1] + y);
			} else if (code == PathIterator.SEG_CLOSE) {
			} else if (code == PathIterator.SEG_CUBICTO) {
				result = result.addPoint(coord[0] + x, coord[1] + y);
				result = result.addPoint(coord[2] + x, coord[3] + y);
				result = result.addPoint(coord[4] + x, coord[5] + y);
			} else if (code == PathIterator.SEG_QUADTO) {
				result = result.addPoint(coord[0] + x, coord[1] + y);
				result = result.addPoint(coord[2] + x, coord[3] + y);
			} else {
				throw new UnsupportedOperationException("code=" + code);
			}
			path.next();
		}

		return result;

	}

}
