// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.klimt.drawing.eps;

import java.io.UnsupportedEncodingException;

import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.font.UFontContext;

public class EpsGraphicsMacroAndText extends EpsGraphicsMacro {

	public void drawText(String text, FontConfiguration fontConfiguration, double x, double y) {
		append(format(x) + " " + format(y) + " moveto", true);
		appendColor(getColor());
		final UFont font = fontConfiguration.getFont();
		final int size = font.getSize();
		append("/" + getPSName(fontConfiguration) + " findfont " + size + " scalefont setfont", true);
		append("100 -100 scale", true);
		append("(" + getTextAsEps(text) + ") show", false);
		append(".01 -.01 scale", true);
	}

	private String getPSName(FontConfiguration fontConfiguration) {
		final UFont font = fontConfiguration.getFont();
		final StringBuilder sb = new StringBuilder(font.getFamily(UFontContext.EPS));
		// final int style = fontConfiguration.getFont().getStyle();
		// final boolean bold = (style & Font.BOLD) != 0 ||
		// fontConfiguration.containsStyle(FontStyle.BOLD);
		// final boolean italic = (style & Font.ITALIC) != 0 ||
		// fontConfiguration.containsStyle(FontStyle.ITALIC);
		// if (bold && italic) {
		// sb.append("-BoldItalic");
		// } else if (bold) {
		// sb.append("-Bold");
		// } else if (italic) {
		// sb.append("-Italic");
		// }
		return sb.toString();
	}

	private String getTextAsEps(String text) {
		final StringBuilder sb = new StringBuilder();
		for (int i = 0; i < text.length(); i++) {
			final char c = text.charAt(i);
			if (c == '\\') {
				sb.append("\\\\");
			} else if (c == '(') {
				sb.append("\\(");
			} else if (c == ')') {
				sb.append("\\)");
			} else if (c < ' ') {
				sb.append("?");
			} else if (c >= ' ' && c <= 127) {
				sb.append(c);
			} else {
				final String s = "" + c;
				try {
					final byte b[] = s.getBytes("ISO-8859-1");
					if (b.length == 1) {
						final int code = b[0] & 0xFF;
						sb.append("\\" + Integer.toOctalString(code));
					} else {
						sb.append('?');
					}
				} catch (UnsupportedEncodingException e) {
					sb.append('?');
				}
			}
		}
		return sb.toString();
	}

}
