// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.klimt.font;

import java.awt.Font;
import java.util.EnumSet;

import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;

public enum FontStyle {

	PLAIN, ITALIC, BOLD, UNDERLINE, STRIKE, WAVE, BACKCOLOR;

	public UFont mutateFont(UFont font) {
		if (this == PLAIN)
			return font.withStyle(Font.PLAIN);

		if (this == ITALIC)
			return font.withStyle(font.getStyle() | Font.ITALIC);

		if (this == BOLD)
			return font.withStyle(font.getStyle() | Font.BOLD);

		return font;
	}

	public String getActivationPattern() {
		if (this == PLAIN)
			return "\\<[pP][lL][aA][iI][nN]\\>";

		if (this == ITALIC)
			return "\\<[iI]\\>";

		if (this == BOLD)
			return "\\<[bB]\\>";

		if (this == UNDERLINE)
			return "\\<[uU](?::(#[0-9a-fA-F]{6}|\\w+))?\\>";

		if (this == WAVE)
			return "\\<[wW](?::(#[0-9a-fA-F]{6}|\\w+))?\\>";

		if (this == BACKCOLOR)
			// return "\\<[bB][aA][cC][kK](?::(#[0-9a-fA-F]{6}|\\w+))?\\>";
			return "\\<[bB][aA][cC][kK](?::(#?\\w+(?:[-\\\\|/]#?\\w+)?))?\\>";

		if (this == STRIKE)
			return "\\<(?:s|S|strike|STRIKE|del|DEL)(?::(#[0-9a-fA-F]{6}|\\w+))?\\>";

		return null;
	}

	public boolean canHaveExtendedColor() {
		if (this == UNDERLINE)
			return true;

		if (this == WAVE)
			return true;

		if (this == BACKCOLOR)
			return true;

		if (this == STRIKE)
			return true;

		return false;
	}

	public String getCreoleSyntax() {
		if (this == ITALIC)
			return "//";

		if (this == BOLD)
			return "\\*\\*";

		if (this == UNDERLINE)
			return "__";

		if (this == WAVE)
			return "~~";

		if (this == STRIKE)
			return "--";

		throw new UnsupportedOperationException();
	}

	// ::comment when __HAXE__
	public HColor getExtendedColor(String s) {
		final Matcher2 m = MyPattern.cmpile(getActivationPattern()).matcher(s);
		if (m.find() == false || m.groupCount() != 1)
			return null;

		final String color = m.group(1);
		if (color == null)
			return null;

		return HColorSet.instance().getColorOrWhite(color);
	}

	public String getDeactivationPattern() {
		if (this == PLAIN)
			return "\\</[pP][lL][aA][iI][nN]\\>";

		if (this == ITALIC)
			return "\\</[iI]\\>";

		if (this == BOLD)
			return "\\</[bB]\\>";

		if (this == UNDERLINE)
			return "\\</[uU]\\>";

		if (this == WAVE)
			return "\\</[wW]\\>";

		if (this == BACKCOLOR)
			return "\\</[bB][aA][cC][kK]\\>";

		if (this == STRIKE)
			return "\\</(?:s|S|strike|STRIKE|del|DEL)\\>";

		return null;
	}

	public static FontStyle getStyle(String line) {
		for (FontStyle style : EnumSet.allOf(FontStyle.class))
			if (line.matches(style.getActivationPattern()) || line.matches(style.getDeactivationPattern()))
				return style;

		throw new IllegalArgumentException(line);
	}

}
