// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.plasma;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * A named node in the entity graph.
 *
 * @see net.sourceforge.plantuml.plasma
 */
public class Quark<DATA> {

	private final Plasma<DATA> plasma;
	private final Quark<DATA> parent;
	private final String name;
	private DATA data;
	private final Map<String, Quark<DATA>> children = new LinkedHashMap<>();
	private final String qualifiedName;

	Quark(Plasma<DATA> plasma, Quark<DATA> parent, String name) {
		this.name = name;
		this.plasma = plasma;
		this.parent = parent;
		if (parent == null || parent.parent == null)
			this.qualifiedName = name;
		else
			this.qualifiedName = parent.qualifiedName + plasma.getSeparator() + name;
		this.plasma.register(this);
	}

	public Quark<DATA> getParent() {
		return parent;
	}

	@Override
	public String toString() {
		return qualifiedName;
	}

	public String toStringPoint() {
		if (parent == null || parent.parent == null)
			return name;

		return parent.toStringPoint() + "." + name;
	}

	public String getName() {
		return name;
	}

	public String getQualifiedName() {
		return qualifiedName;
	}

	public boolean isRoot() {
		return parent == null;
	}

	public final Plasma<DATA> getPlasma() {
		return plasma;
	}

	public final DATA getData() {
		return data;
	}

	public final void setData(DATA data) {
		if (this.data != null)
			throw new IllegalStateException();
		this.data = data;
	}

	public Quark<DATA> childIfExists(String name) {
		if (plasma.hasSeparator() && name.contains(plasma.getSeparator()))
			throw new IllegalArgumentException();
		return children.get(name);
	}

	public Quark<DATA> child(String full) {
		if (plasma.hasSeparator() == false)
			return getDirectChild(full);

		full = clean(full);
		final String separator = plasma.getSeparator();
		Quark<DATA> current = this;
		while (true) {
			int idx = full.indexOf(separator);
			if (idx == -1)
				return current.getDirectChild(full);

			final String first = full.substring(0, idx);
			current = current.getDirectChild(first);
			full = clean(full.substring(idx + separator.length()));
		}
	}

	private Quark<DATA> getDirectChild(String name) {
		Quark<DATA> result = children.get(name);
		if (result == null) {
			result = new Quark<DATA>(plasma, this, name);
			children.put(name, result);
		}
		return result;
	}

	private String clean(String full) {
		final String separator = plasma.getSeparator();
		while (full.startsWith(separator))
			full = full.substring(separator.length());
		while (full.endsWith(separator))
			full = full.substring(0, full.length() - separator.length());

		return full;
	}

	public Collection<Quark<DATA>> getChildren() {
		return Collections.unmodifiableCollection(children.values());
	}

	public int countChildren() {
		return children.size();
	}

}
