// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;

public abstract class SentenceSimple<D extends Diagram> implements Sentence<D> {

	private final Subject<D> subject;
	private final IRegex verb;
	private final IRegex adverbialOrPropositon;
	private final Something<D> complement;

	public SentenceSimple(Subject<D> subject, IRegex verb, Something<D> complement) {
		this(subject, verb, new RegexLeaf(""), complement);
	}

	public SentenceSimple(Subject<D> subject, IRegex verb, IRegex adverbialOrPropositon, Something<D> complement) {
		this.subject = subject;
		this.verb = verb;
		this.adverbialOrPropositon = adverbialOrPropositon;
		this.complement = complement;
	}

	public String getSignature() {
		return subject.getClass() + "/" + verb.getPattern() + "/" + complement.getClass();
	}

	public final IRegex toRegex() {
		if (complement instanceof ComplementEmpty)
			return new RegexConcat(//
					RegexLeaf.start(), //
					subject.toRegex(), //
					RegexLeaf.spaceOneOrMore(), //
					verb, //
					adverbialOrPropositon, //
					OPTIONAL_FINAL_DOT);

		return new RegexConcat(//
				RegexLeaf.start(), //
				subject.toRegex(), //
				RegexLeaf.spaceOneOrMore(), //
				verb, //
				adverbialOrPropositon, //
				RegexLeaf.spaceOneOrMore(), //
				complement.toRegex("0"), //
				OPTIONAL_FINAL_DOT);
	}

	public final CommandExecutionResult execute(D project, RegexResult arg) {
		final Failable<? extends Object> currentSubject = subject.getMe(project, arg);
		if (currentSubject.isFail())
			return CommandExecutionResult.error(currentSubject.getError());

		final Failable<? extends Object> currentComplement = complement.getMe(project, arg, "0");
		if (currentComplement.isFail())
			return CommandExecutionResult.error(currentComplement.getError());

		return execute(project, currentSubject.get(), currentComplement.get());

	}

	public abstract CommandExecutionResult execute(D project, Object subject, Object complement);

	public IRegex getVerbRegex() {
		return verb;
	}

	protected final IRegex getAdverbialOrPropositon() {
		return adverbialOrPropositon;
	}

	protected final Subject<D> getSubject() {
		return subject;
	}

	protected final Something<D> getComplement() {
		return complement;
	}

}
