// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.security.authentication.oauth;

import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

import net.sourceforge.plantuml.json.Json;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.security.authentication.SecurityAuthentication;
import net.sourceforge.plantuml.security.authentication.SecurityAuthorizeManager;

/**
 * Default abstract OAuth2 AccessAuthorizeManager for OAuth2 managers.
 *
 * @author Aljoscha Rittner
 */
public abstract class AbstractOAuth2AccessAuthorizeManager implements SecurityAuthorizeManager {
    // ::remove folder when __HAXE__

	/**
	 * Default headers for token service access.
	 * <p>
	 * Initialize with:
	 * 
	 * <pre>
	 * "Content-Type"="application/x-www-form-urlencoded; charset=UTF-8"
	 * "Accept"="application/json"
	 * </pre>
	 *
	 * @return headers
	 */
	protected Map<String, Object> headers() {
		Map<String, Object> map = new HashMap<>();
		map.put("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
		map.put("Accept", "application/json");
		return map;
	}

	/**
	 * Builds the access parameter map.
	 *
	 * @param tokenResponse the JSOn object with the response data
	 * @param tokenType     token type to use instead of token_type from response
	 * @return data-map
	 */
	protected Map<String, Object> buildAccessDataFromResponse(JsonObject tokenResponse, String tokenType) {
		Map<String, Object> map = new HashMap<>();

		toMap(map, tokenResponse, OAuth2Tokens.ACCESS_TOKEN);
		toMap(map, tokenResponse, OAuth2Tokens.SCOPE);
		toMap(map, tokenResponse, OAuth2Tokens.EXPIRES_IN);

		if (tokenType == null) {
			toMap(map, tokenResponse, OAuth2Tokens.TOKEN_TYPE);
			if (!map.isEmpty() && !map.containsKey(OAuth2Tokens.TOKEN_TYPE.key())) {
				// default token type is bearer
				map.put(OAuth2Tokens.TOKEN_TYPE.key(), "bearer");
			}
		} else {
			// Caller don't belief in the token_type response
			if (!map.isEmpty()) {
				map.put(OAuth2Tokens.TOKEN_TYPE.key(), tokenType);
			}
		}

		return map;
	}

	/**
	 * Translates the JSON value to a map key/value.
	 *
	 * @param map      collection to store
	 * @param response values from response
	 * @param name     name of the value
	 */
	private void toMap(Map<String, Object> map, JsonObject response, OAuth2Tokens name) {
		JsonValue jsonValue = response.get(name.key());
		if (jsonValue != null && !jsonValue.isNull()) {
			if (jsonValue.isString()) {
				map.put(name.key(), jsonValue.asString());
			} else if (jsonValue.isNumber()) {
				map.put(name.key(), jsonValue.asInt());
			} else if (jsonValue.isBoolean()) {
				map.put(name.key(), jsonValue.asBoolean());
			}
		}
	}

	/**
	 * Encodes the data to UTF-8 into {@code application/x-www-form-urlencoded}.
	 *
	 * @param data data to encode
	 * @return the encoded data
	 */
	protected String urlEncode(String data) {
		try {
			return URLEncoder.encode(data, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			Logme.error(e);
			return data;
		}
	}

	/**
	 * Calls the endpoint to load the token response and create a
	 * SecurityAuthentication.
	 *
	 * @param proxy        Proxy for the access
	 * @param grantType    grant type
	 * @param tokenType    token type to use instead of token_type from response
	 * @param tokenService URL to token service
	 * @param content      body content
	 * @param basicAuth    principal basicAuth
	 * @return the authentication object to access resources (or null)
	 */
	protected SecurityAuthentication requestAndCreateAuthFromResponse(Proxy proxy, String grantType, String tokenType,
			SURL tokenService, String content, SecurityAuthentication basicAuth) {
		byte[] bytes = tokenService.getBytesOnPost(proxy, basicAuth, content, headers());
		if (bytes != null) {
			JsonValue tokenResponse = Json.parse(new String(bytes, StandardCharsets.UTF_8));
			if (tokenResponse != null && !tokenResponse.isNull()) {
				return new SecurityAuthentication("oauth2", null, grantType,
						buildAccessDataFromResponse(tokenResponse.asObject(), tokenType));
			}
		}
		return null;
	}
}
