// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.stats;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.stats.api.Stats;
import net.sourceforge.plantuml.utils.Log;

public class StatsUtils {

	final static Preferences prefs = Preferences.userNodeForPackage(StatsUtils.class);

	static ParsedGenerated fullEver;

	static ConcurrentMap<String, ParsedGenerated> byTypeEver = new ConcurrentHashMap<String, ParsedGenerated>();
	static ConcurrentMap<String, ParsedGenerated> byTypeCurrent = new ConcurrentHashMap<String, ParsedGenerated>();

	static FormatCounter formatCounterCurrent = new FormatCounter("currentformat.");
	static FormatCounter formatCounterEver = new FormatCounter("format.");

	static HistoricalData historicalData;

	static boolean xmlStats = false;
	static boolean htmlStats = false;
	static boolean realTimeStats = false;

	public static Stats getStats() {
		return new StatsImpl(byTypeEver, byTypeCurrent, formatCounterCurrent, formatCounterEver, historicalData,
				fullEver);
	}

	private final static int VERSION = 14;

	static {
		try {
			// Logger.getLogger("java.util.prefs").setLevel(Level.OFF);
			Logger.getLogger("java.util.prefs").setFilter(new Filter() {
				public boolean isLoggable(LogRecord record) {
					final String message = record.getMessage();
					System.err.println("SPECIAL TRACE FOR PLANTUML: " + message);
					return false;
				}
			});
		} catch (Exception e) {
			Logme.error(e);
		}
		if (prefs.getInt("VERSION", 0) != VERSION) {
			try {
				prefs.clear();
			} catch (BackingStoreException e1) {
				Logme.error(e1);
			}
			prefs.putInt("VERSION", VERSION);
		}
		restoreNow();
		if (historicalData != null) {
			historicalData.reset();
		}

		Runtime.getRuntime().addShutdownHook(new Thread() {
			@Override
			public void run() {
				endingHook();
			}
		});
	}

	private static void restoreNow() {
		try {
			prefs.sync();
			fullEver = ParsedGenerated.loadDated(prefs, "full");
			historicalData = new HistoricalData(prefs);
			reload();
			formatCounterEver.reload("format.", prefs);
		} catch (BackingStoreException e) {
			Log.error("Error reloading stats " + e);
			byTypeEver.clear();
		}
	}

	private static void reload() throws BackingStoreException {
		for (String key : prefs.keys()) {
			if (key.startsWith("type.") && key.endsWith(".p.saved")) {
				final String name = removeDotPSaved(key);
				final ParsedGenerated p = ParsedGenerated.loadDated(prefs, name);
				if (p != null) {
					byTypeEver.put(name.substring("type.".length()), p);
				}
			}
		}
	}

	static String removeDotPSaved(String key) {
		return key.substring(0, key.length() - ".p.saved".length());
	}

	private static void endingHook() {
		try {
			final Stats stats = getStatsLazzy();
			if (xmlStats) {
				xmlOutput(stats);
			}
			if (htmlStats) {
				htmlOutput(stats);
			}
		} catch (Exception e) {
			Logme.error(e);
		}
	}

	static Stats getStatsLazzy() {
		if (xmlStats || htmlStats) {
			return getStats();
		}
		return null;
	}

	static void htmlOutput(Stats stats) throws FileNotFoundException {
		try (PrintWriter pw = SecurityUtils.createPrintWriter("plantuml-stats.html")) {
			pw.print(new HtmlConverter(stats).toHtml());
		}
	}

	static void xmlOutput(Stats stats) throws TransformerException, ParserConfigurationException, IOException {
		try (OutputStream os = SecurityUtils.createFileOutputStream("plantuml-stats.xml")) {
			new XmlConverter(stats).createXml(os);
		}
	}

	public static void setXmlStats(boolean value) {
		xmlStats = value;
	}

	public static void setHtmlStats(boolean value) {
		htmlStats = value;
	}

	public static void setRealTimeStats(boolean value) {
		realTimeStats = value;
	}

	public static void outHtml() throws FileNotFoundException {
		htmlOutput(getStats());
	}

	public static void dumpStats() {
		new TextConverter(getStats()).printMe(System.out);
	}

	public static void loopStats() throws InterruptedException {
		int linesUsed = 0;
		while (true) {
			restoreNow();
			clearScreen(System.out, linesUsed);
			final TextConverter textConverter = new TextConverter(getStats());
			textConverter.printMe(System.out);
			linesUsed = textConverter.getLinesUsed();
			Thread.sleep(3000L);
		}

	}

	private static void clearScreen(PrintStream ps, int linesUsed) {
		if (linesUsed == 0) {
			return;
		}
		if (SFile.separatorChar == '/') {
			System.out.println(String.format("\033[%dA", linesUsed + 1)); // Move up
		} else {
			for (int i = 0; i < 20; i++) {
				ps.println();
			}
		}
	}
}
