// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.timingdiagram.graphic;

import java.util.ArrayList;
import java.util.List;

import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingNote;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.utils.Position;

public class Ribbon implements PDrawing {

	private final List<ChangeState> changes = new ArrayList<>();
	private final List<TimeConstraint> constraints = new ArrayList<>();

	private final ISkinParam skinParam;
	private final TimingRuler ruler;
	private String initialState;
	private Colors initialColors;
	private final List<TimingNote> notes;
	private final boolean compact;
	private final TextBlock title;
	private final int suggestedHeight;
	private final Style style;

	public Ribbon(TimingRuler ruler, ISkinParam skinParam, List<TimingNote> notes, boolean compact, TextBlock title,
			int suggestedHeight, Style style) {
		this.style = style;
		this.suggestedHeight = suggestedHeight == 0 ? 24 : suggestedHeight;
		this.compact = compact;
		this.ruler = ruler;
		this.skinParam = skinParam;
		this.notes = notes;
		this.title = title;
	}

	public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
		final double x = ruler.getPosInPixel(tick);
		final double y = getHeightForConstraints(stringBounder) + getHeightForNotes(stringBounder, Position.TOP)
				+ getHeightForTopComment(stringBounder) + getRibbonHeight() / 2;
		for (ChangeState change : changes)
			if (change.getWhen().compareTo(tick) == 0)
				return new IntricatedPoint(new XPoint2D(x, y), new XPoint2D(x, y));

		return new IntricatedPoint(new XPoint2D(x, y - getRibbonHeight() / 2),
				new XPoint2D(x, y + getRibbonHeight() / 2));
	}

	public void addChange(ChangeState change) {
		this.changes.add(change);
	}

	private double getPosInPixel(ChangeState change) {
		return ruler.getPosInPixel(change.getWhen());
	}

	private FontConfiguration getFontConfiguration() {
		return FontConfiguration.create(skinParam, style);

	}

	private TextBlock createTextBlock(String value) {
		final Display display = Display.getWithNewlines(value);
		return display.create(getFontConfiguration(), HorizontalAlignment.LEFT, skinParam);
	}

	public TextBlock getPart1(double fullAvailableWidth) {
		return new AbstractTextBlock() {
			public void drawU(UGraphic ug) {
				if (compact) {
					final double titleHeight = title.calculateDimension(ug.getStringBounder()).getHeight();
					final double dy = (getRibbonHeight() - titleHeight) / 2;
					title.drawU(ug.apply(UTranslate.dy(dy)));
				}
			}

			public XDimension2D calculateDimension(StringBounder stringBounder) {
				double width = getInitialWidth(stringBounder);
				if (compact)
					width += title.calculateDimension(stringBounder).getWidth() + 10;

				return new XDimension2D(width, getRibbonHeight());
			}
		};
	}

	public UDrawable getPart2() {
		return new UDrawable() {
			public void drawU(UGraphic ug) {
				drawPart2(ug);
			}
		};
	}

	private void drawNotes(UGraphic ug, final Position position) {
		for (TimingNote note : notes)
			if (note.getPosition() == position) {
				final TimeTick when = note.getWhen();
				final double x = when == null ? 0 : ruler.getPosInPixel(when);
				note.drawU(ug.apply(UTranslate.dx(x)));
			}
	}

	private double getInitialWidth(final StringBounder stringBounder) {
		if (initialState == null)
			return 0;

		return createTextBlock(initialState).calculateDimension(stringBounder).getWidth() + 24;
	}

	private void drawHexa(UGraphic ug, double len, ChangeState change) {
		final HexaShape shape = HexaShape.create(len, getRibbonHeight(), change.getContext(skinParam, style));
		shape.drawU(ug);
	}

	private void drawFlat(UGraphic ug, double len, ChangeState change) {
		final ULine line = ULine.hline(len);
		change.getContext(skinParam, style).apply(ug).apply(UTranslate.dy(getRibbonHeight() / 2)).draw(line);
	}

	private double getRibbonHeight() {
		return suggestedHeight;
	}

	private void drawPentaB(UGraphic ug, double len, ChangeState change) {
		final PentaBShape shape = PentaBShape.create(len, getRibbonHeight(), change.getContext(skinParam, style));
		shape.drawU(ug);
	}

	private void drawPentaA(UGraphic ug, double len, ChangeState change) {
		Fashion context = change.getContext(skinParam, style);
		final HColor back = initialColors.getColor(ColorType.BACK);
		final HColor line = initialColors.getColor(ColorType.LINE);
		if (back != null)
			context = context.withBackColor(back);
		if (line != null)
			context = context.withForeColor(line);

		final PentaAShape shape = PentaAShape.create(len, getRibbonHeight(), context);
		shape.drawU(ug);
	}

	private double getHeightForConstraints(StringBounder stringBounder) {
		return TimeConstraint.getHeightForConstraints(stringBounder, constraints);
	}

	private double getHeightForNotes(StringBounder stringBounder, Position position) {
		double height = 0;
		for (TimingNote note : notes)
			if (note.getPosition() == position)
				height = Math.max(height, note.getHeight(stringBounder));

		return height;
	}

	private double getMarginX() {
		return 12;
	}

	public void setInitialState(String initialState, Colors initialColors) {
		this.initialState = initialState;
		this.initialColors = initialColors;
	}

	public void addConstraint(TimeConstraint constraint) {
		this.constraints.add(constraint);
	}

	public double getFullHeight(StringBounder stringBounder) {
		return getHeightForConstraints(stringBounder) + getHeightForTopComment(stringBounder)
				+ getHeightForNotes(stringBounder, Position.TOP) + getRibbonHeight()
				+ getHeightForNotes(stringBounder, Position.BOTTOM) + getBottomMargin();
	}

	private double getBottomMargin() {
		return 10;
	}

	private void drawPart2(UGraphic ug) {
		final StringBounder stringBounder = ug.getStringBounder();

		final UGraphic ugRibbon = ug.apply(UTranslate.dy(getHeightForConstraints(stringBounder)
				+ getHeightForTopComment(stringBounder) + getHeightForNotes(stringBounder, Position.TOP)));

		drawBeforeZeroState(ugRibbon);
		drawBeforeZeroStateLabel(ugRibbon.apply(UTranslate.dy(getRibbonHeight() / 2)));
		drawStates(ugRibbon);
		drawStatesLabels(ugRibbon.apply(UTranslate.dy(getRibbonHeight() / 2)));

		drawConstraints(ug.apply(UTranslate.dy(getHeightForConstraints(stringBounder) / 2)));

		drawNotes(ug, Position.TOP);
		drawNotes(ug.apply(UTranslate.dy(getHeightForConstraints(stringBounder) + getRibbonHeight()
				+ getHeightForNotes(stringBounder, Position.TOP))), Position.BOTTOM);
	}

	private void drawBeforeZeroState(UGraphic ug) {
		if (initialState == null)
			return;
		final StringBounder stringBounder = ug.getStringBounder();
		if (changes.size() == 0) {
			drawSingle(ug.apply(UTranslate.dx(-getInitialWidth(stringBounder))),
					getInitialWidth(stringBounder) + ruler.getWidth());
		} else {
			final double a = getPosInPixel(changes.get(0));
			drawPentaA(ug.apply(UTranslate.dx(-getInitialWidth(stringBounder))), getInitialWidth(stringBounder) + a,
					changes.get(0));
		}
	}

	private void drawBeforeZeroStateLabel(final UGraphic ug) {
		final StringBounder stringBounder = ug.getStringBounder();
		if (initialState != null) {
			final TextBlock initial = createTextBlock(initialState);
			final XDimension2D dimInital = initial.calculateDimension(stringBounder);
			initial.drawU(ug.apply(new UTranslate(-getMarginX() - dimInital.getWidth(), -dimInital.getHeight() / 2)));
		}
	}

	private void drawSingle(UGraphic ug, double len) {
		final HColor back = style.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet());
		final HColor line = style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
		Fashion context = new Fashion(back, back).withStroke(style.getStroke());
		ug = context.apply(ug);

		final double height = getRibbonHeight();
		final URectangle rect = URectangle.build(len, height);
		ug.draw(rect);

		final ULine border = ULine.hline(len);
		ug = ug.apply(line);
		ug.draw(border);
		ug.apply(UTranslate.dy(height)).draw(border);

	}

	private void drawStates(UGraphic ug) {
		for (int i = 0; i < changes.size() - 1; i++) {
			final double a = getPosInPixel(changes.get(i));
			final double b = getPosInPixel(changes.get(i + 1));
			assert b > a;
			if (changes.get(i).isFlat())
				drawFlat(ug.apply(UTranslate.dx(a)), b - a, changes.get(i));
			else if (changes.get(i).isCompletelyHidden() == false)
				drawHexa(ug.apply(UTranslate.dx(a)), b - a, changes.get(i));
		}
		if (changes.size() >= 1) {
			final ChangeState last = changes.get(changes.size() - 1);
			final double a = getPosInPixel(last);
			if (last.isFlat())
				drawFlat(ug.apply(UTranslate.dx(a)), ruler.getWidth() - a, last);
			else if (last.isCompletelyHidden() == false)
				drawPentaB(ug.apply(UTranslate.dx(a)), ruler.getWidth() - a, last);
		}
	}

	private void drawStatesLabels(UGraphic ug) {
		final StringBounder stringBounder = ug.getStringBounder();
		for (int i = 0; i < changes.size(); i++) {
			final ChangeState change = changes.get(i);
			final double x = ruler.getPosInPixel(change.getWhen());
			if (change.isBlank() == false && change.isCompletelyHidden() == false && change.isFlat() == false) {
				final TextBlock state = createTextBlock(change.getState());
				final XDimension2D dim = state.calculateDimension(stringBounder);
				final double xtext;
				if (i == changes.size() - 1) {
					xtext = x + getMarginX();
				} else {
					final double x2 = ruler.getPosInPixel(changes.get(i + 1).getWhen());
					xtext = (x + x2) / 2 - dim.getWidth() / 2;
				}
				state.drawU(ug.apply(new UTranslate(xtext, -dim.getHeight() / 2)));
			}
			final TextBlock commentTopBlock = getCommentTopBlock(change);
			final XDimension2D dimComment = commentTopBlock.calculateDimension(stringBounder);
			commentTopBlock
					.drawU(ug.apply(new UTranslate(x + getMarginX(), -getRibbonHeight() / 2 - dimComment.getHeight())));
		}
	}

	private TextBlock getCommentTopBlock(final ChangeState change) {
		if (change.getComment() == null)
			return TextBlockUtils.empty(0, 0);

		return createTextBlock(change.getComment());
	}

	private double getHeightForTopComment(StringBounder stringBounder) {
		double result = 0;
		for (ChangeState change : changes)
			result = Math.max(result, getCommentTopBlock(change).calculateDimension(stringBounder).getHeight());

		return result;
	}

	private void drawConstraints(final UGraphic ug) {
		for (TimeConstraint constraint : constraints)
			constraint.drawU(ug, ruler);
	}

}
