// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.webp;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.imageio.stream.ImageInputStream;

import net.sourceforge.plantuml.log.Logme;

public class VP8Decoder {
	private int[][][][] coefProbs;
	VP8Frame f;
	private int frameCount = 0;

	public VP8Decoder() {
		coefProbs = Globals.getDefaultCoefProbs();
	}

	public void decodeFrame(ImageInputStream stream) throws IOException {
		final boolean debug = false;
		coefProbs = Globals.getDefaultCoefProbs();
		f = new VP8Frame(stream, coefProbs);
		if (f.decodeFrame(debug)) {

		}
		frameCount++;
	}

	public VP8Frame getFrame() {
		return f;
	}

	public int getHeight() {
		return f.getHeight();
	}

	public int getWidth() {
		return f.getWidth();
	}

	public void writePGMFile(String fileName, VP8Frame frame) {

		FileOutputStream out;
		try {
			int[][] yData = frame.getYBuffer();
			int[][] uData = frame.getUBuffer();
			int[][] vData = frame.getVBuffer();
			int outStride = (f.getWidth() + 1) & ~1;
			int uvHeight = (f.getHeight() + 1) / 2;
			out = new FileOutputStream(fileName);
			out.write((byte) 'P');
			out.write((byte) '5');
			out.write((byte) 0x0a);
			out.write(("" + outStride).getBytes());
			out.write((byte) ' ');

			out.write(("" + (f.getHeight() + uvHeight)).getBytes());

			out.write((byte) 0x0a);
			out.write(("255").getBytes());
			out.write((byte) 0xa);
			for (int y = 0; y < f.getHeight(); y++) {
				for (int x = 0; x < f.getWidth(); x++) {
					out.write(yData[x][y]);
				}
				if ((f.getWidth() & 1) == 1)
					out.write(0x0);
			}
			for (int y = 0; y < (f.getHeight() + 1) / 2; y++) {
				for (int x = 0; x < (f.getWidth() + 1) / 2; x++) {
					out.write(uData[x][y]);
				}
				for (int x = 0; x < (f.getWidth() + 1) / 2; x++) {
					out.write(vData[x][y]);
				}

			}

		} catch (FileNotFoundException e) {
			Logme.error(e);
		} catch (IOException e) {
			Logme.error(e);
		}
	}

	public void writeYV12File(String fileName, VP8Frame frame) {

		FileOutputStream out;
		try {
			int[][] yData = frame.getYBuffer();
			int[][] uData = frame.getUBuffer();
			int[][] vData = frame.getVBuffer();
			out = new FileOutputStream(fileName);
			out.write((byte) 'P');
			out.write((byte) '5');
			out.write((byte) 0x0a);
			out.write(("" + f.getWidth()).getBytes());
			out.write((byte) ' ');

			out.write(("" + (f.getHeight() * 3 / 2)).getBytes());
			out.write((byte) 0x0a);
			out.write(("255").getBytes());
			out.write((byte) 0xa);
			for (int y = 0; y < f.getHeight(); y++) {
				for (int x = 0; x < f.getWidth(); x++) {
					out.write(yData[x][y]);
				}

			}
			for (int y = 0; y < (f.getHeight() + 1) / 2; y++)
				for (int x = 0; x < (f.getWidth() + 1) / 2; x++) {
					out.write(uData[x][y]);
				}
			for (int y = 0; y < (f.getHeight() + 1) / 2; y++)
				for (int x = 0; x < (f.getWidth() + 1) / 2; x++) {
					out.write(vData[x][y]);
				}
		} catch (FileNotFoundException e) {
			Logme.error(e);
		} catch (IOException e) {
			Logme.error(e);
		}
	}
}
