// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.xmi;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class XmiSequenceDiagramArgo extends XmiSequenceDiagram {
	public XmiSequenceDiagramArgo(SequenceDiagram diagram, Document document) {
		super(diagram, document);
	}

	@Override
	public void build() {
		final Element xmi = document.createElement("XMI");
		xmi.setAttribute("xmi.version", "1.2");
		xmi.setAttribute("xmlns:UML", "href://org.omg/UML/1.3");
		document.appendChild(xmi);

		final Element header = document.createElement("XMI.header");
		xmi.appendChild(header);

		final Element metamodel = document.createElement("XMI.metamodel");
		metamodel.setAttribute("xmi.name", "UML");
		metamodel.setAttribute("xmi.version", "1.4");
		header.appendChild(metamodel);

		final Element content = document.createElement("XMI.content");
		xmi.appendChild(content);

		final Element model = createElement(diagram, "UML:Model");
		model.setAttribute("name", "PlantUML");
		content.appendChild(model);

		Element ownedElement = document.createElement("UML:Namespace.ownedElement");
		model.appendChild(ownedElement);
		ownedElement.appendChild(createCollaborationElement());

		for (Participant participant : diagram.participants()) {
			ownedElement.appendChild(createActorElement(participant));
		}
	}

	private Element createActorElement(Participant participant) {
		Element actor = createElement(participant, "UML:Actor");
		actor.setAttribute("name", String.join(" ", participant.getDisplay(false).asList()));
		return actor;
	}

	private Node createCollaborationElement() {
		Element collaboration = document.createElement("UML:Collaboration");
		Element ownedElement = document.createElement("UML:Namespace.ownedElement");

		for (Participant participant : diagram.participants()) {
			ownedElement.appendChild(createClassifierRole(participant));
		}

		collaboration.appendChild(ownedElement);

		Node messages = collaboration.appendChild((document.createElement("UML:Collaboration.interaction")))
				.appendChild(document.createElement("UML:Interaction"))
				.appendChild(document.createElement("UML:Interaction.message"));

		Message prevMessage = null;
		for (Event event : diagram.events()) {
			if (event instanceof Message) {
				Message message = (Message) event;
				messages.appendChild(createMessage(message, prevMessage));
				ownedElement.appendChild(createSendAction(message));
				prevMessage = message;
			}
		}

		return collaboration;
	}

	private Node createSendAction(Message message) {
		Element sendAction = createElement(message, "UML:SendAction");
		sendAction.appendChild(document.createElement("UML:Action.script"))
				.appendChild(createElement("UML:ActionExpression",
						new String[][] { { "xmi.id", getXmiId("UML:ActionExpression", message) },
								{ "body", getDisplayString(message.getLabel()) } }));
		return sendAction;
	}

	private Element createElement(Object object, String tag) {
		return createElement(tag, new String[][] { { "xmi.id", getXmiId("UML:ActionExpression", object) } });
	}

	private Node createRef(String tag, Object target) {
		Element role = document.createElement(tag);
		role.setAttribute("xmi.idref", getXmiId(tag, target));
		return role;
	}

	private Element createClassifierRole(Participant participant) {
		Element classifierRole = createElement(participant, "UML:ClassifierRole");

		classifierRole.setAttribute("name", participant.getCode());
		classifierRole.appendChild(document.createElement("UML:ClassifierRole.base"))
				.appendChild(createRef("UML:Actor", participant));
		return classifierRole;
	}

	private Element createMessage(Message message, Message prevMessage) {
		Element messageElement = createElement(message, "UML:Message");
		messageElement.appendChild(document.createElement("UML:Message.sender"))
				.appendChild(createRef("UML:ClassifierRole", message.getParticipant1()));
		messageElement.appendChild(document.createElement("UML:Message.receiver"))
				.appendChild(createRef("UML:ClassifierRole", message.getParticipant2()));
		messageElement.appendChild(document.createElement("UML:Message.action"))
				.appendChild(createRef("UML:SendAction", message));

		if (prevMessage != null) {
			messageElement.appendChild(document.createElement("UML:Message.predecessor"))
					.appendChild(createRef("UML:Message", prevMessage));
		}

		return messageElement;
	}

}
