// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.yaml;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.json.JsonArray;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonString;
import net.sourceforge.plantuml.json.JsonValue;

public class SimpleYamlParser {

	private JsonValue result;
	private final List<Integer> pendingIndents = new ArrayList<>();

	public JsonValue parse(List<String> lines) {
		result = new JsonObject();
		pendingIndents.clear();
		pendingIndents.add(0);
		final YamlLines yamlLines = new YamlLines(lines);
		for (String s : yamlLines) {
			parseSingleLine(s);
		}
		return result;

	}

	private String[] nameAndValue(String s) {
		final Pattern p1 = Pattern.compile("^\\s*" + YamlLines.KEY + "\\s*: \\s*(\\S.*)$");
		final Matcher m1 = p1.matcher(s);
		if (m1.matches()) {
			final String name = m1.group(1);
			final String data = m1.group(2).trim();
			return new String[] { name, data };
		}
		return null;
	}

	private void parseSingleLine(String s) {
		final int indent = getIndent(s);
//		System.err.println("s=" + s);

		if (isListStrict(s)) {
			strictMuteToArray(indent);
			return;
		}

		final String listedValue = listedValue(s);
		if (listedValue != null) {
			final JsonArray array = getForceArray(indent);
			array.add(listedValue);
			return;
		}

		final JsonObject working = (JsonObject) getWorking(indent);
		if (working == null) {
			System.err.println("ERROR: ignoring " + s);
			return;
		}

		final String[] nameAndValue = nameAndValue(s);
		if (nameAndValue != null) {
			final String name = nameAndValue[0];
			final String data = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(nameAndValue[1], "\"");
			working.add(name, data);
			return;
		}

		final String nameOnly = YamlLines.nameOnly(s);
		if (nameOnly != null) {
			working.add(nameOnly, new JsonObject());
			return;
		}

		throw new UnsupportedOperationException(s);
	}

	private String listedValue(String s) {
		final Pattern p1 = Pattern.compile("^\\s*[-]\\s*(\\S.*)$");
		final Matcher m1 = p1.matcher(s);
		if (m1.matches()) {
			final String name = m1.group(1).trim();
			return name;
		}
		return null;
	}

	private JsonArray getForceArray(int indent) {
		if (indent == 0 && getLastIndent() == 0) {
			if (result instanceof JsonArray == false) {
				result = new JsonArray();
			}
			return (JsonArray) result;
		}
		while (getLastIndent() > indent - 1)
			pendingIndents.remove(pendingIndents.size() - 1);

		final JsonObject last = (JsonObject) search(result, pendingIndents.size());
		final String field = last.names().get(last.size() - 1);
		if (last.get(field) instanceof JsonArray == false) {
			last.set(field, new JsonArray());
		}
		return (JsonArray) last.get(field);
	}

	private void strictMuteToArray(int indent) {
		if (indent == 0 && getLastIndent() == 0) {
			if (result instanceof JsonArray == false) {
				result = new JsonArray();
			}
			return;
		}
		while (getLastIndent() > indent)
			pendingIndents.remove(pendingIndents.size() - 1);

		if (result instanceof JsonArray) {
			((JsonArray) result).add(new JsonObject());
			return;
		}

		final JsonObject last = (JsonObject) search(result, pendingIndents.size());
		final String field = last.names().get(last.size() - 1);
		if (last.get(field) instanceof JsonArray == false) {
			last.set(field, new JsonArray());
		} else {
			((JsonArray) last.get(field)).add(new JsonObject());
		}
	}

	private boolean isListStrict(String s) {
		return s.trim().equals("-");
	}

	private int getLastIndent() {
		return pendingIndents.get(pendingIndents.size() - 1);
	}

	private JsonValue getWorking(int indent) {
		if (indent > getLastIndent()) {
			pendingIndents.add(indent);
			return search(result, pendingIndents.size());
		}
		if (indent == getLastIndent()) {
			return search(result, pendingIndents.size());
		}
		final int idx = pendingIndents.indexOf(indent);
		if (idx == -1) {
			return null;
		}

		while (pendingIndents.size() > idx + 1)
			pendingIndents.remove(pendingIndents.size() - 1);

		return search(result, pendingIndents.size());
	}

	private static JsonValue search(JsonValue current1, int size) {
		if (current1 instanceof JsonArray) {
			JsonArray array = (JsonArray) current1;

			final JsonValue tmp;
			if (array.size() == 0) {
				tmp = new JsonObject();
				array.add(tmp);
			} else {
				tmp = array.get(array.size() - 1);
			}
			return tmp;
		}
		if (size <= 1) {
			return current1;
		}

		final JsonObject current = (JsonObject) current1;
		final String last = current.names().get(current.size() - 1);
		// System.err.println("last=" + last);
		JsonValue tmp = current.get(last);
		if (tmp instanceof JsonArray) {
			JsonArray array = (JsonArray) tmp;
			if (array.size() == 0) {
				tmp = new JsonObject();
				array.add(tmp);
			} else {
				tmp = array.get(array.size() - 1);
			}
		}
		if (tmp instanceof JsonString) {
			System.err.println("JsonString? " + tmp);
			return null;
		}
		return search(tmp, size - 1);
	}

	private int getIndent(String s) {
		int indent = 0;
		for (int i = 0; i < s.length(); i++) {
			final char ch = s.charAt(i);
			if (ch == ' ' || ch == '\t') {
				indent++;
			} else {
				return indent;
			}
		}
		return 0;
	}

}
