// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package org.stathissideris.ascii2image.graphics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.stathissideris.ascii2image.core.DebugUtils;
import org.stathissideris.ascii2image.text.CellSet;
import org.stathissideris.ascii2image.text.TextGrid;

/**
 * 
 * @author Efstathios Sideris
 */
public class CompositeDiagramShape extends DiagramComponent {

	private static final boolean DEBUG = false;

	private ArrayList<DiagramShape> shapes = new ArrayList<DiagramShape>();

	public static void main(String[] args) {
	}

	public static DiagramComponent createFromBoundaryCells(
			final TextGrid grid,
			final CellSet boundaryCells,
			final int cellWidth,
			final int cellHeight) {
				return createOpenFromBoundaryCells(
						grid,
						boundaryCells,
						cellWidth, cellHeight,
						false);
	}


	public static DiagramComponent createOpenFromBoundaryCells(
			final TextGrid grid,
			final CellSet boundaryCells,
			final int cellWidth,
			final int cellHeight,
			boolean allRound) {
		
		if(boundaryCells.getType(grid) != CellSet.TYPE_OPEN) throw new IllegalArgumentException("This shape is closed and cannot be handled by this method");
		if(boundaryCells.size() == 0) return null;

		
		CompositeDiagramShape compositeShape = new CompositeDiagramShape();
		TextGrid workGrid = new TextGrid(grid.getWidth(), grid.getHeight());
		grid.copyCellsTo(boundaryCells, workGrid);

		if(DEBUG) {
			System.out.println("Making composite shape from grid:");
			workGrid.printDebug();
		}
		
		
		CellSet visitedCells = new CellSet();
		
		List<DiagramShape> shapes = new ArrayList<DiagramShape>(100);
		
		for(TextGrid.Cell cell : boundaryCells) {
			if(workGrid.isLinesEnd(cell)) {
				CellSet nextCells = workGrid.followCell(cell);
				shapes.addAll(growEdgesFromCell(workGrid, cellWidth, cellHeight, allRound, nextCells.getFirst(), cell, visitedCells));
				break;
			}
		}
		
		//dashed shapes should "infect" the rest of the shapes
		boolean dashedShapeExists = false;
		for(DiagramShape shape : shapes)
			if(shape.isStrokeDashed())
				dashedShapeExists = true;
		
		for(DiagramShape shape : shapes) {
			if(dashedShapeExists) shape.setStrokeDashed(true);
			compositeShape.addToShapes(shape);
		}
		
		return compositeShape;
	}
	
	
	private static List<DiagramShape> growEdgesFromCell(
			TextGrid workGrid,
			final int cellWidth,
			final int cellHeight,
			boolean allRound,
			TextGrid.Cell cell, 
			TextGrid.Cell previousCell, 
			CellSet visitedCells) {
		
		List<DiagramShape> result = new ArrayList<DiagramShape>(50); 
		
		visitedCells.add(previousCell);
		
		DiagramShape shape = new DiagramShape();
		
		shape.addToPoints(makePointForCell(previousCell, workGrid, cellWidth, cellHeight, allRound));
		if(DEBUG) System.out.println("point at "+previousCell+" (call from line: "+DebugUtils.getLineNumber()+")");
		if(workGrid.cellContainsDashedLineChar(previousCell)) shape.setStrokeDashed(true);

		boolean finished = false;
		int nb = 0;
		while(!finished) {
			// https://github.com/plantuml/plantuml/issues/1036
			nb++;
			if (nb > 1000)
				return result;
			visitedCells.add(cell);
			if(workGrid.isPointCell(cell)) {
				if(DEBUG) System.out.println("point at "+cell+" (call from line: "+DebugUtils.getLineNumber()+")");
				shape.addToPoints(makePointForCell(cell, workGrid, cellWidth, cellHeight, allRound));
			}
			
			if(workGrid.cellContainsDashedLineChar(cell)) shape.setStrokeDashed(true);

			if(workGrid.isLinesEnd(cell)){
				finished = true;
				if(DEBUG) System.out.println("finished shape");
			}
			
			CellSet nextCells = workGrid.followCell(cell, previousCell);
			if(nextCells.size() == 1) {
				previousCell = cell;
				cell = (TextGrid.Cell) nextCells.getFirst();
			} else if(nextCells.size() > 1) {//3- or 4- way intersection
				finished = true;
				if(DEBUG) System.out.println("finished shape");
				for(TextGrid.Cell nextCell : nextCells)
					result.addAll(growEdgesFromCell(workGrid, cellWidth, cellHeight, allRound, nextCell, cell, visitedCells));
			}
		}
		
		result.add(shape);
		return result;
	}

	/**
	 * Returns a new diagram component with the lines of
	 * this CompositeDiagramShape connected. It can a composite
	 * or simple shape
	 * 
	 * @return
	 */
	public DiagramComponent connectLines(){
		CompositeDiagramShape result = new CompositeDiagramShape();

		//find all lines
		ArrayList<DiagramShape> lines = new ArrayList<DiagramShape>();
		Iterator it = shapes.iterator();
		while(it.hasNext()){
			DiagramShape shape = (DiagramShape) it.next();
			if(shape.getPoints().size() == 2){
				lines.add(shape);
			}
		}
		
		it = lines.iterator();
		while(it.hasNext()){
			DiagramShape line1 = (DiagramShape) it.next();
			Iterator it2 = lines.iterator();
			while(it2.hasNext()){
				DiagramShape line2 = (DiagramShape) it.next();
				ShapePoint commonPoint = null;
				ShapePoint line1UncommonPoint = null;
				ShapePoint line2UncommonPoint = null;
				if(line1.getPoint(0).equals(line2.getPoint(0))){
					commonPoint = line1.getPoint(0);
					line1UncommonPoint = line1.getPoint(1);
					line2UncommonPoint = line2.getPoint(1);
				}
				if(line1.getPoint(0).equals(line2.getPoint(1))){
					commonPoint = line1.getPoint(0);
					line1UncommonPoint = line1.getPoint(1);
					line2UncommonPoint = line2.getPoint(0);
				}
				if(line1.getPoint(1).equals(line2.getPoint(0))){
					commonPoint = line1.getPoint(1);
					line1UncommonPoint = line1.getPoint(0);
					line2UncommonPoint = line2.getPoint(1);
				}
				if(line1.getPoint(1).equals(line2.getPoint(1))){
					commonPoint = line1.getPoint(1);
					line1UncommonPoint = line1.getPoint(0);
					line2UncommonPoint = line2.getPoint(0);
				}
				if(commonPoint != null){
					
				}
			}
		}
		
		return result;
	}

	public void connectEndsToAnchors(TextGrid grid, Diagram diagram){
		Iterator it = shapes.iterator();
		while (it.hasNext()) {
			DiagramShape shape = (DiagramShape) it.next();
			if(!shape.isClosed()){
				shape.connectEndsToAnchors(grid, diagram);
			}
		}
	}

	private static DiagramShape makeLine(TextGrid grid, TextGrid.Cell start, TextGrid.Cell end, int cellWidth, int cellHeight){
		DiagramShape line = new DiagramShape();
		
		if(grid.isHorizontalLine(start)){
			if(start.isWestOf(end)){
				line.addToPoints(new ShapePoint(
							Diagram.getCellMinX(start, cellWidth),
							Diagram.getCellMidY(start, cellHeight)));
			} else {
				line.addToPoints(new ShapePoint(
							Diagram.getCellMaxX(start, cellWidth),
							Diagram.getCellMidY(start, cellHeight)));
			}
		} else if(grid.isVerticalLine(start)){
			if(start.isNorthOf(end)){
				line.addToPoints(new ShapePoint(
							Diagram.getCellMidX(start, cellWidth),
							Diagram.getCellMinY(start, cellHeight)));
			} else {
				line.addToPoints(new ShapePoint(
							Diagram.getCellMidX(start, cellWidth),
							Diagram.getCellMaxY(start, cellHeight)));
			}			
		} else { //corner
			if(DEBUG) System.out.println("Corner");
			int type = (grid.isRoundCorner(start))?ShapePoint.TYPE_ROUND:ShapePoint.TYPE_NORMAL;
			line.addToPoints(new ShapePoint(
						Diagram.getCellMidX(start, cellWidth),
						Diagram.getCellMidY(start, cellHeight),
						type));
			
		}

		if(grid.isHorizontalLine(end)){
			if(start.isWestOf(start)){
				line.addToPoints(new ShapePoint(
							Diagram.getCellMinX(end, cellWidth),
							Diagram.getCellMidY(end, cellHeight)));
			} else {
				line.addToPoints(new ShapePoint(
							Diagram.getCellMaxX(end, cellWidth),
							Diagram.getCellMidY(end, cellHeight)));
			}
		} else if(grid.isVerticalLine(end)){
			if(start.isNorthOf(start)){
				line.addToPoints(new ShapePoint(
							Diagram.getCellMidX(end, cellWidth),
							Diagram.getCellMinY(end, cellHeight)));
			} else {
				line.addToPoints(new ShapePoint(
							Diagram.getCellMidX(end, cellWidth),
							Diagram.getCellMaxY(end, cellHeight)));
			}			
		} else { //corner
			int type = (grid.isRoundCorner(end))?ShapePoint.TYPE_ROUND:ShapePoint.TYPE_NORMAL;
			if(DEBUG) System.out.println("Corner");
			line.addToPoints(new ShapePoint(
						Diagram.getCellMidX(end, cellWidth),
						Diagram.getCellMidY(end, cellHeight),
						type));
			
		}

		
		return line;
	}

	public void addToShapes(DiagramShape shape){
		shapes.add(shape);
	}
	
	private Iterator getShapesIterator(){
		return shapes.iterator();
	}
	
	public void scale(float factor){
		Iterator it = getShapesIterator();
		while(it.hasNext()){
			DiagramShape shape = (DiagramShape) it.next();
			shape.scale(factor);
		}
	}
	/**
	 * @return
	 */
	public ArrayList getShapes() {
		return shapes;
	}

}

