// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package org.stathissideris.ascii2image.text;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * 
 * @author Efstathios Sideris
 */
public class AbstractionGrid {

	private static final boolean DEBUG = false;
	
	private TextGrid grid;
	
	/**
	 * Makes an AbstractionGrid using <code>internalGrid</code> as
	 * its internal buffer
	 * 
	 * @param internalGrid
	 * @return
	 */
	public static AbstractionGrid makeUsingBuffer(TextGrid internalGrid){
		if(internalGrid.getWidth() % 3 != 0
			|| internalGrid.getHeight() % 3 != 0) throw new IllegalArgumentException("Passed TextGrid must have dimensions that are divisible by 3."); 
		AbstractionGrid result = new AbstractionGrid(internalGrid.getWidth() / 3, internalGrid.getHeight() / 3);
		result.setInternalBuffer(internalGrid);
		return result;
	}
	
	/**
	 * Makes an AbstractionGrid using the <code>cellSet</code>
	 * of <code>textGrid</code>.
	 * 
	 * @param textGrid
	 * @param cellSet
	 */
	public AbstractionGrid(TextGrid textGrid, CellSet cellSet){
		this(textGrid.getWidth(), textGrid.getHeight());
		/*this(cellSet.getWidth(), cellSet.getHeight());
		
		cellSet = new CellSet(cellSet);
		cellSet.translate( - cellSet.getMinX(), - cellSet.getMinY());*/
		
		if(DEBUG){
			System.out.println("Making AbstractionGrid using buffer:");
			textGrid.printDebug();
			System.out.println("...and the following CellSet:");
			cellSet.printAsGrid();
		}
		
		Iterator it = cellSet.iterator();
		while(it.hasNext()){
			TextGrid.Cell cell = (TextGrid.Cell) it.next();
			if(textGrid.isBlank(cell)) continue;
			if(textGrid.isCross(cell)){
				set(cell.x, cell.y, AbstractCell.makeCross());
			} else if(textGrid.isT(cell)){
				set(cell.x, cell.y, AbstractCell.makeT());
			} else if(textGrid.isK(cell)){
				set(cell.x, cell.y, AbstractCell.makeK());
			} else if(textGrid.isInverseT(cell)){
				set(cell.x, cell.y, AbstractCell.makeInverseT());
			} else if(textGrid.isInverseK(cell)){
				set(cell.x, cell.y, AbstractCell.makeInverseK());
			} else if(textGrid.isCorner1(cell)){
				set(cell.x, cell.y, AbstractCell.makeCorner1());
			} else if(textGrid.isCorner2(cell)){
				set(cell.x, cell.y, AbstractCell.makeCorner2());
			} else if(textGrid.isCorner3(cell)){
				set(cell.x, cell.y, AbstractCell.makeCorner3());
			} else if(textGrid.isCorner4(cell)){
				set(cell.x, cell.y, AbstractCell.makeCorner4());
			} else if(textGrid.isHorizontalLine(cell)){
				set(cell.x, cell.y, AbstractCell.makeHorizontalLine());
			} else if(textGrid.isVerticalLine(cell)){
				set(cell.x, cell.y, AbstractCell.makeVerticalLine());
			} else if(textGrid.isCrossOnLine(cell)){
				set(cell.x, cell.y, AbstractCell.makeCross());
			} else if(textGrid.isStarOnLine(cell)){
				set(cell.x, cell.y, AbstractCell.makeStar());
			}
		}

		if(DEBUG){
			System.out.println("...the resulting AbstractionGrid is:");
			grid.printDebug();
		}
	}
	
	private AbstractionGrid(int width, int height){
		grid = new TextGrid(width*3, height*3);
	}
	
	public TextGrid getCopyOfInternalBuffer(){
		return new TextGrid(grid);
	}

	private void setInternalBuffer(TextGrid grid){
		this.grid = grid;
	}

	
	public int getWidth(){
		return grid.getWidth() / 3;
	}

	public int getHeight(){
		return grid.getHeight() / 3;
	}

	public TextGrid getAsTextGrid(){
		TextGrid result = new TextGrid(getWidth(), getHeight());
		for(int y = 0; y < grid.getHeight(); y++){
			for(int x = 0; x < grid.getWidth(); x++){
				TextGrid.Cell cell = grid.new Cell(x, y);
				if(!grid.isBlank(cell)) result.set(x/3, y/3, '*');
			}
		}
		if (DEBUG){
			System.out.println("Getting AbstractionGrid as textGrid.\nAbstractionGrid:");
			grid.printDebug();
			System.out.println("...as text grid:");
			result.printDebug();
		}

		return result;
	}

	public ArrayList getDistinctShapes(){
		ArrayList result = new ArrayList();
		
		CellSet nonBlank = grid.getAllNonBlank();
		ArrayList distinct = nonBlank.breakIntoDistinctBoundaries();
		
		Iterator it = distinct.iterator();
		while (it.hasNext()) {
			CellSet set = (CellSet) it.next();
			AbstractionGrid temp = new AbstractionGrid(this.getWidth(), this.getHeight());
			temp.fillCells(set);
			result.add(temp.getAsTextGrid().getAllNonBlank());
		}
		
		return result; 
	}
	
	protected void fillCells(CellSet cells){
		grid.fillCellsWith(cells, '*');
	}
	
	public void set(int xPos, int yPos, AbstractCell cell){
		xPos *= 3;
		yPos *= 3;
		for(int y = 0; y < 3; y++){
			for(int x = 0; x < 3; x++){
				if(cell.rows[x][y] == 1){
					grid.set(xPos + x, yPos + y, '*');
				}
			}
		}
	}

}
