// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package org.stathissideris.ascii2image.text;

/**
 * @author sideris
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class StringUtils {

	/**
	 * The indexOf idiom
	 * 
	 * @param big
	 * @param fragment
	 * @return
	 */
	public static boolean contains(String big, String fragment){
		return (big.indexOf(fragment) != -1);
	}
	
	public static String repeatString(String string, int repeats){
		if(repeats == 0) return "";
		String buffer = "";
		for(int i=0; i < repeats; i++){
			buffer += string;
		}
		return buffer;
	}
	
	/*public static String repeatString(String string, int repeats){
		if(repeats == 0) return "";
		StringBuffer buffer = new StringBuffer("");
		for(int i=0; i < repeats; i++){
			buffer.append(string);
		}
		return buffer.toString();
	}*/
	
	public static boolean isBlank(String s){
		return (s.length() == 0 || s.matches("^\\s*$"));
	}
	
	/**
	 * 
	 * Converts the first character of <code>string</code> into a capital letter
	 * 
	 * @param string
	 * @return
	 */
	public static String firstToUpper(String string){
		return string.substring(0,1).toUpperCase()+string.substring(1);
	}
	
	public static String insertSpaceAtCaps(String string){

		int uppers = 0;

		//first we count
		for(int i=0; i < string.length(); i++){
			if(Character.isUpperCase(string.charAt(i))) uppers++;
		}

		int[] indexes = null;
		
		if(Character.isUpperCase(string.charAt(0))){		
			indexes = new int[uppers];
		} else {
			indexes = new int[++uppers];
		}
		indexes[0] = 0;		
		int k = 1;

		//then we find the indexes (we have ckecked the first char already)
		for(int j =1; j < string.length(); j++){
			if(Character.isUpperCase(string.charAt(j))) indexes[k++] = j;
		}
		
		StringBuffer buffer = new StringBuffer("");
		//and finally we breakup the String
		for(int i =0; i < indexes.length; i++){
			if(i+1 < indexes.length){
				buffer.append(string.substring(indexes[i], indexes[i+1]));
				buffer.append(" ");
			} else {
				buffer.append(string.substring(indexes[i]));
			}			
		}
		return buffer.toString();
	}
	
	
	public static boolean isOneOf(char c, char[] group){
		for(int i = 0; i < group.length; i++)
			if(c == group[i]) return true;
		return false;
	}

	public static boolean isOneOf(String str, String[] group){
		for(int i = 0; i < group.length; i++)
			if(str.equals(group[i])) return true;
		return false;
	}

	public static String getPath(String fullPath){
		if(fullPath.lastIndexOf("\\") != -1)
			return fullPath.substring(0, fullPath.lastIndexOf("\\"));
		else return "";
	}

	public static String getBaseFilename(String fullPath){
		if(fullPath.lastIndexOf(".") != -1 && fullPath.lastIndexOf("\\") != -1)
			return fullPath.substring(fullPath.lastIndexOf("\\") + 1, fullPath.lastIndexOf("."));
		else return fullPath; 
	}

	public static String getExtension(String fullPath){
		if(fullPath.lastIndexOf(".") != -1)
			return fullPath.substring(fullPath.lastIndexOf(".") + 1);
		else return "";
	}

	
	public static void main(String[] args){
		System.out.println("1 "+StringUtils.firstToUpper("testing"));
		System.out.println("2 "+StringUtils.firstToUpper(" testing"));
		System.out.println("3 "+StringUtils.firstToUpper("_testing"));
		System.out.println("4 "+StringUtils.firstToUpper("Testing"));
		System.out.println("5 "+StringUtils.firstToUpper("ttesting"));
		String path = "C:\\Files\\test.txt";
		System.out.println(path);
		System.out.println(StringUtils.getPath(path));
		System.out.println(StringUtils.getBaseFilename(path));
		System.out.println(StringUtils.getExtension(path));
		
		path = "test.txt";
		System.out.println(path);
		System.out.println(StringUtils.getPath(path));
		System.out.println(StringUtils.getBaseFilename(path));
		System.out.println(StringUtils.getExtension(path));

		path = "test";
		System.out.println(path);
		System.out.println("path: "+StringUtils.getPath(path));
		System.out.println("base: "+StringUtils.getBaseFilename(path));
		System.out.println(" ext: "+StringUtils.getExtension(path));


	}
}
