// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package zext.plantuml.com.ctreber.acearth;

import zext.plantuml.com.ctreber.acearth.util.Coordinate;
import zext.plantuml.com.ctreber.aclib.gui.MOBoolean;
import zext.plantuml.com.ctreber.aclib.gui.MODouble;
import zext.plantuml.com.ctreber.aclib.gui.MOEnum;
import zext.plantuml.com.ctreber.aclib.gui.MOInteger;
import zext.plantuml.com.ctreber.aclib.gui.MOString;
import zext.plantuml.com.ctreber.aclib.gui.MonitoredObject;

/**
 * <p>
 * How to avoid writing all the accessors? Code generator that creates derived
 * class from template class? Configuration items in data structure?
 * </p>
 * 
 * <p>
 * &copy; 2002 Christian Treber, ct@ctreber.com (06.10.2002)
 * </p>
 * 
 * @author Christian Treber, ct@ctreber.com
 * 
 */
public class ConfigurationACearth extends Configuration {
	private static final int DEFAULT_DIMENSION = 512;

	public ConfigurationACearth() {
		final MOEnum lProjection = new MOEnum();
		lProjection.addValidValue("Mercator");
		lProjection.addValidValue("Orthographic");
		lProjection.addValidValue("Cylindrical");
		lProjection.set("Orthographic");
		add("projection", (MonitoredObject) lProjection);

		final MOEnum lPositionType = new MOEnum();
		lPositionType.addValidValue("Fixed");
		lPositionType.addValidValue("Sun-relative");
		lPositionType.addValidValue("Orbit");
		lPositionType.addValidValue("Random");
		lPositionType.addValidValue("Moon");
		lPositionType.set("Sun-relative");
		add("viewPositionType", lPositionType);

		final MOEnum lViewRotationType = new MOEnum();
		lViewRotationType.addValidValue("North");
		lViewRotationType.addValidValue("Galactic");
		lViewRotationType.set("North");
		add("viewRotationType", lViewRotationType);

		final MOString lOutputMode = new MOString("gui");
		add("outputMode", lOutputMode);

		// Only relevant if view type is "Fixed"./
		final MODouble lViewPosLat = new MODouble(0, -90, +90);
		add("viewPosLat", lViewPosLat);
		final MODouble lViewPosLong = new MODouble(0, -180, +180);
		add("viewPosLong", lViewPosLong);
		// Only relevant if view type is "Sun-relative".
		final MODouble lSunPosRelLat = new MODouble(0, -90, +90);
		add("sunPosRelLat", lSunPosRelLat);
		final MODouble lSunPosRelLong = new MODouble(0, -180, +180);
		add("sunPosRelLong", lSunPosRelLong);

		final MOBoolean lSunMovesP = new MOBoolean(true);
		add("sunMovesP", lSunMovesP);
		// Only relevant if sun does not move.
		final MODouble lSunPosLat = new MODouble(0, -90, +90);
		add("sunPosLat", lSunPosLat);
		final MODouble lSunPosLong = new MODouble(0, -180, +180);
		add("sunPosLong", lSunPosLong);

		final MODouble lTimeWarpFactor = new MODouble(1.0, 0, Double.MAX_VALUE);
		add("timeWarpFactor", lTimeWarpFactor);
		final MOInteger lFixedTime = new MOInteger(0, 0, Integer.MAX_VALUE);
		add("fixedTime", lFixedTime);
		final MOInteger lWaitTime = new MOInteger(300, 0, Integer.MAX_VALUE);
		add("waitTime", lWaitTime);

		final MODouble lOrbitPeriod = new MODouble(1, 0.0001, Double.MAX_VALUE);
		add("orbitPeriod", lOrbitPeriod);
		final MODouble lOrbitInclination = new MODouble(45.0, 0, 90);
		add("orbitInclination", lOrbitInclination);

		final MOBoolean lLabelP = new MOBoolean(false);
		add("labelP", lLabelP);

		final MOInteger lImageWidth = new MOInteger(DEFAULT_DIMENSION, 0, Integer.MAX_VALUE);
		add("imageWidth", lImageWidth);
		final MOInteger lImageHeight = new MOInteger(DEFAULT_DIMENSION, 0, Integer.MAX_VALUE);
		add("imageHeight", lImageHeight);

		final MOBoolean lStarsP = new MOBoolean(true);
		add("starsP", lStarsP);
		final MODouble lStarFrequency = new MODouble(0.002, 0, Double.MAX_VALUE);
		add("starFrequency", lStarFrequency);
		final MOInteger lBigStars = new MOInteger(0, 0, 100);
		add("bigStars", lBigStars);

		final MOBoolean lGridP = new MOBoolean(true);
		add("gridP", lGridP);
		final MOInteger lGridDivision = new MOInteger(6, 0, Integer.MAX_VALUE);
		add("gridDivision", lGridDivision);
		final MOInteger lGridPixelDevision = new MOInteger(15, 0, Integer.MAX_VALUE);
		add("gridPixelDivision", lGridPixelDevision);

		final MOInteger lShiftX = new MOInteger(0, 0, Integer.MAX_VALUE);
		add("shiftX", lShiftX);
		final MOInteger lShiftY = new MOInteger(0, 0, Integer.MAX_VALUE);
		add("shiftY", lShiftY);
		final MODouble lViewMagnification = new MODouble(1.0, 0, Double.MAX_VALUE);
		add("viewMagnification", lViewMagnification);

		final MOBoolean lShadeP = new MOBoolean(true);
		add("shadeP", lShadeP);
		final MOInteger lDaySideBrightness = new MOInteger(100, 0, 100);
		add("daySideBrightness", lDaySideBrightness);
		final MOInteger lNightSideBrightness = new MOInteger(5, 0, 100);
		add("nightSideBrightness", lNightSideBrightness);
		final MOInteger lTerminatorDiscontinuity = new MOInteger(1, 0, 100);
		add("terminatorDiscontinuity", lTerminatorDiscontinuity);

		final MODouble lViewRotation = new MODouble(0, 0, Double.MAX_VALUE);
		add("viewRotation", lViewRotation);
	}

	public Coordinate getViewPos() {
		return new Coordinate(getDouble("viewPosLat"), getDouble("viewPosLong"));
	}

	public void setViewPos(Coordinate pViewPos) {
		setDouble("viewPosLat", pViewPos.getLat());
		setDouble("viewPosLong", pViewPos.getLong());
	}

	public Coordinate getSunPos() {
		return new Coordinate(getDouble("sunPosLat"), getDouble("sunPosLong"));
	}
	
	public void setSunPos(Coordinate pSunPos) {
		setDouble("sunPosLat", pSunPos.getLat());
		setDouble("sunPosLong", pSunPos.getLong());
	}

	public Coordinate getSunPosRel() {
		return new Coordinate(getDouble("sunPosRelLat"), getDouble("sunPosRelLong"));
	}

	public void setSunPosRel(Coordinate pSunPosRel) {
		setDouble("sunPosRelLat", pSunPosRel.getLat());
		setDouble("sunPosRelLong", pSunPosRel.getLong());
	}
}
