// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package zext.plantuml.com.ctreber.acearth.shader;

import java.awt.Color;

import zext.plantuml.com.ctreber.acearth.projection.Projection;
import zext.plantuml.com.ctreber.acearth.scanbit.BitGeneratorMap;
import zext.plantuml.com.ctreber.acearth.util.Coordinate;
import zext.plantuml.com.ctreber.acearth.util.Point3D;

/**
 * <p>A shader computes Colors for a row of pixel types, depending
 * on lighting parameters.</p>
 *
 * <p>&copy; 2002 Christian Treber, ct@ctreber.com (Nov 11, 2002)</p>
 * @author Christian Treber, ct@ctreber.com
 *
 */
abstract public class Shader
{
    // ::remove folder when __HAXE__
  private static final Color COLOR_SPACE = Color.black;
  private static final Color COLOR_STAR = Color.white;
  private static final Color COLOR_WATER = Color.blue;
  private static final Color COLOR_LAND = Color.green;
  // Brown
  //static final Color COLOR_LAND = new Color(255, 136, 25);
  private static final Color COLOR_GRID_LAND = Color.white;
  // Bright blue
  private static final Color COLOR_GRID_WATER = new Color(128, 128, 255);

  /** <p>Needed to calculate lighting vectors. */
  Projection fProjection;

  // Stuff below only needed when shading.
  private Coordinate fSunPos;
  private double fNightSideBrightness;
  private double fDaySideBrightness;
  private double fTerminatorDiscontinuity;

  private double fDaySideValueBase;
  private double fDaySideValueRange;
  Point3D fLightVector;

  abstract public Color[] getShadedColors(int pRowNo, int[] pRowTypes);

  public void init()
  {
    // Precompute shading parameters. I personally find the terminator
    // stuff is obscure and might as well be left out.
    final double tmp = fTerminatorDiscontinuity / 100;
    // 100%: day, 0%: night
    fDaySideValueBase = (int)(tmp * fDaySideBrightness +
      (1 - tmp) * fNightSideBrightness);
    fDaySideValueRange = fDaySideBrightness - fDaySideValueBase;
    fLightVector = fProjection.rotate(fSunPos.getPoint3D());
  }

  Color getShadedColorForType(int pType, double pSunValue)
  {
    double lBrightness;

    if(pSunValue < 0)
    {
      // The sun is below the horizon.
      lBrightness = fNightSideBrightness / 100;
    } else
    {
      // The sun is above the horizon. The brightness will range from
      // the base to the maximum value.
      lBrightness = (fDaySideValueBase + pSunValue * fDaySideValueRange) / 100;
    }
    if(lBrightness > 1.0)
    {
      lBrightness = 1.0;
    }

    switch(pType)
    {
      case BitGeneratorMap.PixTypeSpace:
        return COLOR_SPACE;

      case BitGeneratorMap.PixTypeStar:
        return COLOR_STAR;

      case BitGeneratorMap.PixTypeGridLand:
        return shade(COLOR_GRID_LAND, lBrightness);

      case BitGeneratorMap.PixTypeGridWater:
        return shade(COLOR_GRID_WATER, lBrightness);

      case BitGeneratorMap.PixTypeLand:
        return shade(COLOR_LAND, lBrightness);

      case BitGeneratorMap.PixTypeWater:
        return shade(COLOR_WATER, lBrightness);
    }

    return null;
  }

  private static Color shade(Color pColor, double pBrightness)
  {
    return new Color((int)(pColor.getRed() * pBrightness),
      (int)(pColor.getGreen() * pBrightness),
      (int)(pColor.getBlue() * pBrightness));
  }

  public void setProjection(Projection pProjection)
  {
    fProjection = pProjection;
  }

  public void setSunPos(Coordinate pSunPos)
  {
    fSunPos = pSunPos;
  }

  public void setDaySideBrightness(double pDaySideBrightness)
  {
    fDaySideBrightness = pDaySideBrightness;
  }

  public void setNightSideBrightness(double pNightSideBrightness)
  {
    fNightSideBrightness = pNightSideBrightness;
  }

  public void setTerminatorDiscontinuity(double pTerminatorDiscontinuity)
  {
    fTerminatorDiscontinuity = pTerminatorDiscontinuity;
  }
}
