// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package zext.plantuml.com.ctreber.acearth.util;

import java.util.HashSet;
import java.util.StringTokenizer;

/**
 * <p>Some tools.
 *
 * <p>&copy; 2002 Christian Treber, ct@ctreber.com
 * @author Christian Treber, ct@ctreber.com
 *
 */
public class Toolkit
{
  public static final double TWOPI = Math.PI * 2;
  public static final double PI = Math.PI;
  public static final double HALFPI = Math.PI / 2;
  private static final HashSet fsNoCap;

  static
  {
    fsNoCap = new HashSet();
    fsNoCap.add("a");
    fsNoCap.add("as");
    fsNoCap.add("to");
    fsNoCap.add("of");
    fsNoCap.add("the");
    fsNoCap.add("off");
    fsNoCap.add("and");
    fsNoCap.add("mid");
  }

  public static double degsToRads(double pDegrees)
  {
    return pDegrees * TWOPI / 360;
  }

  public static double radsToDegs(double pRadians)
  {
    return pRadians * 360 / TWOPI;
  }

  /**
   * Force an angular value into the range [-PI, +PI]
   */
  public static double limitRads(double x)
  {
    return fmod(x, -Math.PI, Math.PI);
  }

  /**
   * <p>Verified.
   */
  public static double fmod(double pValue, double pMod)
  {
    while(pValue < 0)
    {
      pValue += pMod;
    }
    while(pValue > pMod)
    {
      pValue -= pMod;
    }

    return pValue;
  }

  /**
   * <p>Examples: min -2, max 2: range 4
   *
   * <ul>
   * <li> value 1: lFact = 0
   * <li> value 3: lFact = 1, value -1
   * <li> value 9: lFact = 2, value 1
   * <li> value -3: lFact = -1, value 1
   * </ul>
   */
  public static double fmod(double pValue, double pMinValue, double pMaxValue)
  {
    final double lRange = pMaxValue - pMinValue;
    int lFact = (int)((pValue - pMinValue) / lRange);
    if(pValue < pMinValue)
    {
      lFact--;
    }

    return pValue - lFact * lRange;
  }

  /**
   * <p>Capitalize String. Uppercase words smaller/equal than 3 chars,
   * lowercase defined exceptions. Capitalize within word after '.' and '-'.
   * Capitalize all others.
   */
  public static String intelligentCapitalize(String pText)
  {
    boolean lDoCap = false;
    final StringTokenizer lST = new StringTokenizer(pText, ".- ", true);
    final StringBuilder lSB = new StringBuilder(50);
    while(lST.hasMoreTokens())
    {
      String lWord = lST.nextToken();

      if(lWord.equals(".") || lWord.equals("-"))
      {
        lDoCap = true;
        lSB.append(lWord);
        continue;
      }
      if(lWord.equals(" "))
      {
        lDoCap = false;
        lSB.append(lWord);
        continue;
      }

      if(lDoCap || (lWord.length() > 3))
      {
        lSB.append(Character.toUpperCase(lWord.charAt(0)));
        lSB.append(lWord.substring(1).toLowerCase());
      } else
      {
        if(fsNoCap.contains(lWord.toLowerCase()))
        {
          lSB.append(lWord.toLowerCase());
        } else
        {
          lSB.append(lWord.toUpperCase());
        }
      }
    }

    return lSB.toString();
  }
}
