// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License V2.
 *
 * THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE PUBLIC
 * LICENSE ("AGREEMENT"). [GNU General Public License V2]
 *
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
 * RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 *
 * You may obtain a copy of the License at
 *
 * https://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this GPL v2 license.
 *
 * The generated images can then be used without any reference to the GPL v2 license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package zext.plantuml.com.ctreber.aclib.sort;

import java.util.Comparator;

/**
 * &copy; 2001 Christian Treber, ct@ctreber.com
 * @author Christian Treber, ct@ctreber.com
 */
public class QuickSort extends CTSort
{
  public void sort(Object[] items, Comparator comparator)
  {
    if(items.length <= 1)
    {
      // Nothing to sort t all or only one element.
      return;
    }

    qsort(items, comparator, 0, items.length - 1);
    insertionSort(items, comparator, 0, items.length - 1);
  }

  private void qsort(Object[] items, Comparator comparator, int l, int r)
  {
    final int M = 4;
    int i;
    int j;
    Object v;

    if((r - l) > M)
    {
      i = (r + l) / 2;
      if(comparator.compare(items[l], items[i]) > 0)
      {
        swap(items, l, i);
      }
      if(comparator.compare(items[l], items[r]) > 0)
      {
        swap(items, l, r);
      }
      if(comparator.compare(items[i], items[r]) > 0)
      {
        swap(items, i, r);
      }

      j = r - 1;
      swap(items, i, j);
      i = l;
      v = items[j];
      while(true)
      {
        while(comparator.compare(items[++i], v) < 0)
        {
        }
        while(comparator.compare(items[--j], v) > 0)
        {
        }
        if(j < i)
        {
          break;
        }
        swap(items, i, j);
      }
      swap(items, i, r - 1);
      qsort(items, comparator, l, j);
      qsort(items, comparator, i + 1, r);
    }
  }

  private static void swap(Object[] items, int i, int j)
  {
    final Object tmp;
    tmp = items[i];
    items[i] = items[j];
    items[j] = tmp;
  }

  private static void insertionSort(Object[] items, Comparator comparator, int lo0, int hi0)
  {
    int i;
    int j;
    Object v;

    for(i = lo0 + 1; i <= hi0; i++)
    {
      v = items[i];
      j = i;
      while((j > lo0) && (comparator.compare(items[j - 1], v) > 0))
      {
        items[j] = items[j - 1];
        j--;
      }
      items[j] = v;
    }
  }
}
