/*
 * Decompiled with CFR 0.152.
 */
package zext.plantuml.com.ctreber.acearth.scandot;

import java.util.Random;
import zext.plantuml.com.ctreber.acearth.scandot.ScanDot;
import zext.plantuml.com.ctreber.acearth.scandot.ScanDotGenerator;

public class DotGeneratorStars
extends ScanDotGenerator {
    private final int fImageWidth;
    private final int fImageHeight;
    private int fBigStars;
    private double fStarFrequency;
    private final Random lRandom;

    public DotGeneratorStars(int pWidth, int pHeight, double pStarFrequency, int pBigStars, Random rnd) {
        this.lRandom = rnd;
        this.fImageWidth = pWidth;
        this.fImageHeight = pHeight;
        this.fStarFrequency = pStarFrequency;
        this.fBigStars = pBigStars;
    }

    @Override
    public void generateScanDots() {
        int lStarsMax = (int)((double)(this.fImageWidth * this.fImageHeight) * this.fStarFrequency);
        for (int i = 0; i < lStarsMax; ++i) {
            int x = (int)(this.lRandom.nextDouble() * (double)(this.fImageWidth - 1));
            int y = (int)(this.lRandom.nextDouble() * (double)this.fImageHeight);
            this.fDots.add(new ScanDot(0, x, y));
            if (this.fBigStars == 0 || !(Math.random() * 100.0 < (double)this.fBigStars)) continue;
            this.fDots.add(new ScanDot(0, x + 1, y));
        }
    }
}

