// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.posimo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;

import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;

public class SimpleDrawer {

	private final Cluster root;
	private final Collection<Path> paths;

	public SimpleDrawer(Cluster root, Collection<Path> paths) {
		this.root = root;
		this.paths = paths;
	}

	public void draw(Graphics2D g2d) {
		g2d.setColor(Color.BLACK);
		for (Clusterable cl : root.getContents()) {
			final Block b = (Block) cl;
			final XPoint2D pos = b.getPosition();
			final XDimension2D dim = b.getSize();
			// drawRectCentered(g2d, pos, dim);
			drawRect(g2d, pos, dim);
		}

		g2d.setColor(Color.GREEN);
		for (Path p : paths) {
			final Label label = p.getLabel();
			final XPoint2D labelPos = label.getPosition();
			final XDimension2D labelDim = label.getSize();
			// final double x1 = labelPos.getX();
			// final double y1 = labelPos.getY();
			// g2d.draw(new Ellipse2D.Double(x1 - 1, y1 - 1, 3, 3));
			// drawRectCentered(g2d, labelPos, labelDim);
			drawRect(g2d, labelPos, labelDim);
		}

		g2d.setColor(Color.RED);
		for (Path p : paths) {
			p.getDotPath().draw(g2d, 0, 0);
		}

		for (Cluster sub : root.getSubClusters()) {
			new SimpleDrawer(sub, new ArrayList<Path>()).draw(g2d);
		}

	}

	private void drawRectCentered(Graphics2D g2d, final XPoint2D pos, final XDimension2D dim) {
		final Rectangle2D rect = new Rectangle2D.Double(pos.getX() - dim.getWidth() / 2,
				pos.getY() - dim.getHeight() / 2, dim.getWidth(), dim.getHeight());
		g2d.draw(rect);
	}

	private void drawRect(Graphics2D g2d, final XPoint2D pos, final XDimension2D dim) {
		final Rectangle2D rect = new Rectangle2D.Double(pos.getX(), pos.getY(), dim.getWidth(), dim.getHeight());
		g2d.draw(rect);
	}
}
