// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.project.LabelStrategy;
import net.sourceforge.plantuml.project.ToTaskDraw;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class TaskDrawGroup extends AbstractTaskDraw {

	private final Day end;

	private final ISkinParam skinParam;

	public TaskDrawGroup(TimeScale timeScale, Real y, String prettyDisplay, Day start, Day end, ISkinParam skinParam,
			Task task, ToTaskDraw toTaskDraw, StyleBuilder styleBuilder) {
		super(timeScale, y, prettyDisplay, start, skinParam, task, toTaskDraw, styleBuilder);
		this.skinParam = skinParam;
		this.end = end;
	}

	@Override
	protected double getShapeHeight(StringBounder stringBounder) {
		final Style style = getStyle();
		final ClockwiseTopRightBottomLeft padding = style.getPadding();
		// return padding.getTop() +
		// getTitle().calculateDimension(stringBounder).getHeight() +
		// padding.getBottom() + 8;
		final double pos1 = timeScale.getStartingPosition(start) + 6;
		final double pos2 = timeScale.getEndingPosition(end) - 6;
		final TextBlock title = getTitle();
		final XDimension2D dim = title.calculateDimension(stringBounder);
		if (pos2 - pos1 > dim.getWidth())
			return dim.getHeight() + 2;
		else
			return dim.getHeight();
	}

	@Override
	public void drawTitle(UGraphic ug, LabelStrategy labelStrategy, double colTitles, double colBars) {
		final TextBlock title = getTitle();
		final StringBounder stringBounder = ug.getStringBounder();
		final XDimension2D dim = title.calculateDimension(stringBounder);

		final Style style = getStyleSignature().getMergedStyle(getStyleBuilder());
		final ClockwiseTopRightBottomLeft margin = style.getMargin();
		final ClockwiseTopRightBottomLeft padding = style.getPadding();

		final double pos1 = timeScale.getStartingPosition(start) + 6;
		final double pos2 = timeScale.getEndingPosition(end) - 6;
		final double pos;
		final double y;
		if (pos2 - pos1 > dim.getWidth()) {
			pos = pos1 + (pos2 - pos1 - dim.getWidth()) / 2;
			// y = margin.getTop() + padding.getTop();
			y = 0;
		} else {
			pos = pos2 + 6;
			y = (getFullHeightTask(stringBounder) - dim.getHeight());
		}
		title.drawU(ug.apply(new UTranslate(pos, y)));
	}

	@Override
	protected TextBlock getTitle() {
		return Display.getWithNewlines(prettyDisplay).create(getFontConfiguration(), HorizontalAlignment.LEFT,
				new SpriteContainerEmpty());
	}

	@Override
	StyleSignatureBasic getStyleSignature() {
		return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.task);
	}

	public void drawU(UGraphic ug) {
		// final double startPos = timeScale.getStartingPosition(start);
		ug = applyColors(ug);
		drawShape(ug);
	}

	@Override
	public double getHeightMax(StringBounder stringBounder) {
		return getFullHeightTask(stringBounder);
	}

	public FingerPrint getFingerPrint(StringBounder stringBounder) {
		final double h = getFullHeightTask(stringBounder);
		final double startPos = timeScale.getStartingPosition(start);
		final double endPos = timeScale.getEndingPosition(end);
		return new FingerPrint(startPos, getY(stringBounder).getCurrentValue(), endPos - startPos, h);
	}

	public FingerPrint getFingerPrintNote(StringBounder stringBounder) {
		return null;
	}

	private UGraphic applyColors(UGraphic ug) {
		final CenterBorderColor col = this.getColors();
		if (col != null && col.isOk())
			return col.apply(ug);

		return ug.apply(getLineColor()).apply(getBackgroundColor().bg());
	}

	public double getX1(TaskAttribute taskAttribute) {
		final Style style = getStyleSignature().getMergedStyle(getStyleBuilder());
		final ClockwiseTopRightBottomLeft margin = style.getMargin();
		final double startPos = taskAttribute == TaskAttribute.START ? timeScale.getStartingPosition(start)
				: timeScale.getStartingPosition(end) + margin.getLeft();
		return startPos;
	}

	public double getX2(TaskAttribute taskAttribute) {
		final Style style = getStyleSignature().getMergedStyle(getStyleBuilder());
		final ClockwiseTopRightBottomLeft margin = style.getMargin();
		final double endPos = taskAttribute == TaskAttribute.START ? timeScale.getEndingPosition(start)
				: timeScale.getEndingPosition(end) - margin.getLeft();
		return endPos;
	}

	private void drawShape(UGraphic ug) {
		final Style style = getStyleSignature().getMergedStyle(getStyleBuilder());
		final ClockwiseTopRightBottomLeft margin = style.getMargin();

		final double startPos = timeScale.getStartingPosition(start) + margin.getLeft();
		final double endPos = timeScale.getEndingPosition(end) - margin.getRight();

		if (url != null)
			ug.startUrl(url);

		// ug = ug.apply(UTranslate.dy(margin.getTop() + 7));
		ug = ug.apply(UTranslate.dy(getFullHeightTask(ug.getStringBounder()) - height));

		ug = ug.apply(HColors.BLACK).apply(HColors.BLACK.bg());
		ug.draw(getShape(startPos, endPos));

		if (url != null)
			ug.closeUrl();

	}

	final private double height = 10;

	private UPath getShape(final double startPos, final double endPos) {
		final UPath rect = UPath.none();

		final double thick = 2;
		final double y1 = (height - thick) / 2;
		final double y2 = height - (height - thick) / 2;
		final double dx = 6;

		rect.moveTo(startPos, 0);
		rect.lineTo(startPos + dx, y1);
		rect.lineTo(endPos - dx, y1);
		rect.lineTo(endPos, 0);
		rect.lineTo(endPos, height);
		rect.lineTo(endPos - dx, y2);
		rect.lineTo(startPos + dx, y2);
		rect.lineTo(startPos, height);
		rect.lineTo(startPos, 0);

		rect.closePath();
		return rect;
	}

	private UPath getShapeOld2(final double startPos, final double endPos) {
		final UPath rect = UPath.none();

		final double height1 = 9;
		final double height2 = 7;
		final double dx = 6;

		rect.moveTo(startPos, 0);
		rect.lineTo(startPos + dx, height2);
		rect.lineTo(endPos - dx, height2);
		rect.lineTo(endPos, 0);
		rect.lineTo(endPos, height1);
		rect.lineTo(startPos, height1);
		rect.lineTo(startPos, 0);

		rect.closePath();
		return rect;
	}

	private UPath getShapeOld(final double startPos, final double endPos) {
		final UPath rect = UPath.none();

		final double height1 = 9;
		final double height2 = 2;
		final double dx = 6;

		rect.moveTo(startPos, 0);
		rect.lineTo(endPos, 0);
		rect.lineTo(endPos, height1);
		rect.lineTo(endPos - dx, height2);
		rect.lineTo(startPos + dx, height2);
		rect.lineTo(startPos, height1);
		rect.lineTo(startPos, 0);
		rect.closePath();
		return rect;
	}

}
