// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.quantization;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class HashMultiset<E> extends AbstractCollection<E> implements Multiset<E> {
	private final Map<E, Count> elementCounts = new HashMap<>();
	private int size;

	public HashMultiset() {
	}

	public HashMultiset(Collection<E> source) {
		addAll(source);
	}

	@Override
	public void add(E element, int n) {
		Count count = elementCounts.get(element);
		if (count != null)
			count.value += n;
		else
			elementCounts.put(element, new Count(n));

		size += n;
	}

	@Override
	public boolean add(E element) {
		add(element, 1);
		return true;
	}

	@Override
	public int remove(Object element, int n) {
		Count count = elementCounts.get(element);
		if (count == null)
			return 0;

		if (n < count.value) {
			count.value -= n;
			size -= n;
			return n;
		}

		elementCounts.remove(element);
		size -= count.value;
		return count.value;
	}

	@Override
	public boolean remove(Object element) {
		return remove(element, 1) > 0;
	}

	@Override
	public Iterator<E> iterator() {
		return new HashMultisetIterator();
	}

	@Override
	public int size() {
		return size;
	}

	@Override
	public int count(Object element) {
		Count countOrNull = elementCounts.get(element);
		return countOrNull != null ? countOrNull.value : 0;
	}

	@Override
	public Set<E> getDistinctElements() {
		return elementCounts.keySet();
	}

	private final class HashMultisetIterator implements Iterator<E> {
		final private Iterator<Map.Entry<E, Count>> distinctElementIterator;
		private E currentElement;
		private int currentCount;
		private boolean currentElementRemoved;

		HashMultisetIterator() {
			this.distinctElementIterator = elementCounts.entrySet().iterator();
			this.currentCount = 0;
		}

		@Override
		public boolean hasNext() {
			return currentCount > 0 || distinctElementIterator.hasNext();
		}

		@Override
		public E next() {
			if (hasNext() == false)
				throw new NoSuchElementException("iterator has been exhausted");

			if (currentCount == 0) {
				Map.Entry<E, Count> next = distinctElementIterator.next();
				currentElement = next.getKey();
				currentCount = next.getValue().value;
			}

			currentCount--;
			currentElementRemoved = false;
			return currentElement;
		}

		@Override
		public void remove() {
			if (currentElement == null)
				throw new IllegalStateException("next() has not been called");

			if (currentElementRemoved)
				throw new IllegalStateException("remove() already called for current element");

			HashMultiset.this.remove(currentElement);
		}
	}

	private static final class Count {
		private int value;

		Count(int value) {
			this.value = value;
		}
	}
}
