// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.quantization;

import java.awt.image.BufferedImage;

import net.sourceforge.plantuml.klimt.color.ColorMapper;

/**
 * An immutable grid of pixel colors.
 */
public final class QImage {
	/**
	 * The first index corresponds to the row, while the second index corresponds
	 * the column.
	 */
	private final QColor[][] colors;

	private QImage(QColor[][] colors) {
		this.colors = colors;
	}

	public static QImage fromBufferedImage(ColorMapper mapper, BufferedImage img) {
		final int height = img.getHeight();
		final int width = img.getWidth();
		final QColor[][] colors = new QColor[height][width];

		if (img.getType() == BufferedImage.TYPE_INT_ARGB) {
			for (int y = 0; y < height; y++)
				for (int x = 0; x < width; x++)
					colors[y][x] = QColor.fromArgbInt(mapper, img.getRGB(x, y));
		} else if (img.getType() == BufferedImage.TYPE_INT_RGB) {
			for (int y = 0; y < height; y++)
				for (int x = 0; x < width; x++)
					colors[y][x] = QColor.fromRgbInt(img.getRGB(x, y));
		} else {
			throw new IllegalArgumentException();
		}

		return new QImage(colors);
	}

	public static QImage fromColors(QColor[][] colors) {
		return new QImage(colors);
	}

	public QColor getColor(int x, int y) {
		return colors[y][x];
	}

	public QColor getColor(int index) {
		return colors[index / getWidth()][index % getWidth()];
	}

	Multiset<QColor> getColors() {
		final Multiset<QColor> colorCounts = new HashMultiset<>();
		for (int i = 0; i < getNumPixels(); ++i) {
			final QColor color = getColor(i);
			colorCounts.add(color);
		}
		return colorCounts;
	}

	public int getWidth() {
		return colors[0].length;
	}

	public int getHeight() {
		return colors.length;
	}

	public int getNumPixels() {
		return getWidth() * getHeight();
	}

	public BufferedImage toBufferedImage() {
		final BufferedImage result = new BufferedImage(getWidth(), getHeight(), BufferedImage.TYPE_INT_RGB);
		for (int i = 0; i < result.getWidth(); i++)
			for (int j = 0; j < result.getHeight(); j++)
				result.setRGB(i, j, colors[j][i].getRgbInt());
		return result;
	}

	public BufferedImage toBufferedImageKeepTransparency(BufferedImage orig) {
		final BufferedImage result = new BufferedImage(getWidth(), getHeight(), BufferedImage.TYPE_INT_ARGB);
		for (int i = 0; i < result.getWidth(); i++)
			for (int j = 0; j < result.getHeight(); j++) {
				if ((orig.getRGB(i, j)) != 0x00000000)
					result.setRGB(i, j, colors[j][i].getRgbInt() | 0xFF000000);
			}
		return result;
	}

}
