// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.regex;

import java.util.concurrent.atomic.AtomicLong;

import net.sourceforge.plantuml.text.StringLocated;

public final class RegexConcat extends RegexComposed implements IRegex {

	private final AtomicLong foxRegex = new AtomicLong(-1L);
	private int limitSize;

	// private static final Set<String> PRINTED2 = new HashSet<>();

	public static void printCacheInfo() {
//		if (OptionFlags.getInstance().isVerbose())
//			synchronized (cache) {
//
//				final NumberFormat nf = NumberFormat.getInstance(Locale.US);
//
//				int nbCompiled = 0;
//				int nbInvoked = 0;
//				for (RegexConcat reg : cache.values()) {
//					if (reg.isCompiled())
//						nbCompiled++;
//
//					if (reg.invoked())
//						nbInvoked++;
//
//				}
//				Log.info("Regex total/invoked/compiled " + nf.format(cache.size()) + "/" + nf.format(nbInvoked) + "/"
//						+ nf.format(nbCompiled));
//				Log.info("Matches escaped " + nf.format(vescaped.get()) + "/" + nf.format(vtot.get()));
//				Log.info("Matches created " + nf.format(nbCreateMatches.get()));
//			}
	}

	public RegexConcat(IRegex... partials) {
		super(partials);
	}

	private long foxRegex() {
		final long result = foxRegex.get();
		if (result == -1L) {
			long tmp = 0L;
			for (int i = 1; i < partials().size() - 1; i++) {
				final IRegex part = partials().get(i);
				if (part instanceof RegexLeaf) {
					final RegexLeaf leaf = (RegexLeaf) part;
					tmp = tmp | leaf.getFoxSignature();
				}
			}
			foxRegex.set(tmp);
			return tmp;
		}
		return result;
	}

	public static RegexConcat build(String key, IRegex... partials) {
		return buildInternal(partials);
//		RegexConcat result = cache.get(key);
//		if (result == null) {
//			cache.putIfAbsent(key, buildInternal(partials));
//			result = cache.get(key);
//			// System.err.println("cache size=" + cache.size());
//			// } else {
//			// synchronized (PRINTED2) {
//			// if (PRINTED2.contains(key) == false) {
//			// System.err.println("if (key.equals(\"" + key + "\")) return
//			// buildInternal(partials);");
//			// }
//			// PRINTED2.add(key);
//		}
//		return result;
	}

	private static RegexConcat buildInternal(IRegex... partials) {
		final RegexConcat result = new RegexConcat(partials);
		assert partials[0] == RegexLeaf.start();
		assert partials[partials.length - 1] == RegexLeaf.end();
		return result;
	}

	private boolean invoked() {
		return foxRegex.get() != -1L;
	}

//	static private final Set<String> PRINTED = new HashSet<>();
//	static private final Set<String> ZERO = new HashSet<>();

	@Override
	public boolean match(StringLocated s) {
		if (limitSize != 0 && s.getString().length() > limitSize)
			return false;

		// vtot.incrementAndGet();
		final long foxRegex = foxRegex();
//		synchronized (PRINTED) {
//			final String full = getFullSlow();
//			final boolean added = PRINTED.add(full);
//			if (added && foxRegex == 0L) {
//				ZERO.add(full);
//				System.err.println("PR " + ZERO.size() + "/" + PRINTED.size() + " "
//						+ FoxSignature.backToString(foxRegex) + " " + full);
//			}
//		}
		if (foxRegex != 0L) {
			final long foxLine = s.getFoxSignature();
			final long check = foxRegex & foxLine;
			// System.err.println("r=" + getFullSlow() + " s=" + s + " line=" + foxLine + "
			// regex" + foxRegex + " "
			// + check + " <" + FoxSignature.backToString(check) + ">");
			if (check != foxRegex) {
				// vescaped.incrementAndGet();
				return false;
			}

		}
		return super.match(s);
	}

	@Override
	protected String getFullSlow() {
		final StringBuilder sb = new StringBuilder();
		for (IRegex p : partials())
			sb.append(p.getPattern());

		return sb.toString();
	}

	public RegexConcat protectSize(int size) {
		limitSize = size;
		return this;
	}

}
