// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LineOfSegments {

	static private class Segment implements Comparable<Segment> {
		private final int idx;
		private double middle;
		private final double halfSize;

		private Segment(int idx, double x1, double x2) {
			this.idx = idx;
			this.middle = (x1 + x2) / 2;
			this.halfSize = (x2 - x1) / 2;
		}

		@Override
		public int compareTo(Segment other) {
			return Double.compare(this.middle, other.middle);
		}

		private double overlap(Segment other) {
			final double distance = other.middle - this.middle;
			if (distance < 0)
				throw new IllegalArgumentException();
			final double diff = distance - this.halfSize - other.halfSize;
			if (diff > 0)
				return 0;
			return -diff;
		}

		private void push(double delta) {
			middle += delta;
		}
	}

	private final List<Segment> all = new ArrayList<>();

	public void addSegment(double x1, double x2) {
		all.add(new Segment(all.size(), x1, x2));
	}

	public double getMean() {
		double sum = 0;
		for (Segment seg : all)
			sum += seg.middle;

		return sum / all.size();
	}

	void solveOverlapsInternal() {
		if (all.size() < 2)
			return;
		Collections.sort(all);
		for (int i = 0; i < all.size(); i++)
			if (oneLoop() == false)
				return;
	}

	private boolean oneLoop() {
		for (int i = all.size() - 2; i >= 0; i--) {
			final Segment seg1 = all.get(i);
			final Segment seg2 = all.get(i + 1);
			final double overlap = seg1.overlap(seg2);
			if (overlap > 0) {
				for (int k = i + 1; k < all.size(); k++)
					all.get(k).push(overlap);
				return true;
			}
		}
		return false;

	}

	public double[] solveOverlaps() {
		final double mean1 = getMean();
		solveOverlapsInternal();
		final double mean2 = getMean();
		final double diff = mean1 - mean2;
		if (diff != 0)
			for (Segment seg : all)
				seg.push(diff);
		final double[] result = new double[all.size()];
		for (Segment seg : all)
			result[seg.idx] = seg.middle - seg.halfSize;
		return result;

	}

}
