// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.decoration;

import java.util.Objects;

import net.sourceforge.plantuml.abel.LinkStrategy;
import net.sourceforge.plantuml.klimt.UStroke;

public class LinkType {

	private final LinkDecor decor1;
	private final LinkStyle linkStyle;
	private final LinkDecor decor2;
	private final LinkMiddleDecor middleDecor;

	public boolean isDoubleDecorated() {
		return decor1 != LinkDecor.NONE && decor2 != LinkDecor.NONE;
	}

	public boolean looksLikeRevertedForSvg() {
		if (this.decor1 == LinkDecor.NONE && this.decor2 != LinkDecor.NONE)
			return true;

		return false;
	}

	public boolean looksLikeNoDecorAtAllSvg() {
		if (this.decor1 == LinkDecor.NONE && this.decor2 == LinkDecor.NONE)
			return true;

		if (this.decor1 != LinkDecor.NONE && this.decor2 != LinkDecor.NONE)
			return true;

		return false;
	}

	public LinkType(LinkDecor decor1, LinkDecor decor2) {
		this(decor1, decor2, LinkMiddleDecor.NONE, LinkStyle.NORMAL());
	}

	private LinkType(LinkDecor decor1, LinkDecor decor2, LinkMiddleDecor middleDecor, LinkStyle style) {
		this.decor1 = decor1;
		this.decor2 = decor2;
		this.middleDecor = middleDecor;
		this.linkStyle = Objects.requireNonNull(style);
	}

	public LinkType withoutDecors1() {
		return new LinkType(LinkDecor.NONE, decor2, middleDecor, linkStyle);
	}

	public LinkType withoutDecors2() {
		return new LinkType(decor1, LinkDecor.NONE, middleDecor, linkStyle);
	}

	// public boolean contains(LinkDecor decors) {
	// return decor1 == decors || decor2 == decors;
	// }

	@Override
	public String toString() {
		return decor1 + "-" + linkStyle + "-" + decor2;
	}

	@Override
	public int hashCode() {
		return toString().hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		final LinkType other = (LinkType) obj;
		return this.decor1 == other.decor1 && this.decor2 == other.decor2 && this.linkStyle == other.linkStyle;
	}

	public boolean isInvisible() {
		return linkStyle.isInvisible();
	}

	public LinkType goDashed() {
		return new LinkType(decor1, decor2, middleDecor, LinkStyle.DASHED());
	}

	public LinkType goDotted() {
		return new LinkType(decor1, decor2, middleDecor, LinkStyle.DOTTED());
	}

	public LinkType goThickness(double thickness) {
		return new LinkType(decor1, decor2, middleDecor, linkStyle.goThickness(thickness));
	}

	public LinkType goBold() {
		return new LinkType(decor1, decor2, middleDecor, LinkStyle.BOLD());
	}

	public LinkType getInversed() {
		return new LinkType(decor2, decor1, middleDecor.getInversed(), linkStyle);
	}

	public LinkType withMiddleCircle() {
		return new LinkType(decor1, decor2, LinkMiddleDecor.CIRCLE, linkStyle);
	}

	public LinkType withMiddleCircleCircled() {
		return new LinkType(decor1, decor2, LinkMiddleDecor.CIRCLE_CIRCLED, linkStyle);
	}

	public LinkType withMiddleCircleCircled1() {
		return new LinkType(decor1, decor2, LinkMiddleDecor.CIRCLE_CIRCLED1, linkStyle);
	}

	public LinkType withMiddleCircleCircled2() {
		return new LinkType(decor1, decor2, LinkMiddleDecor.CIRCLE_CIRCLED2, linkStyle);
	}

	public LinkType getInvisible() {
		return new LinkType(decor1, decor2, middleDecor, LinkStyle.INVISIBLE());
	}

	public String getSpecificDecorationSvek(LinkStrategy linkStrategy) {

		if (linkStrategy == LinkStrategy.SIMPLIER)
			return "arrowtail=none,arrowhead=none";

		final StringBuilder sb = new StringBuilder();

		final boolean isEmpty1 = decor1 == LinkDecor.NONE;
		final boolean isEmpty2 = decor2 == LinkDecor.NONE;

		if (isEmpty1 && isEmpty2) {
			sb.append("arrowtail=none");
			sb.append(",arrowhead=none");
		} else if (isEmpty1 == false && isEmpty2 == false) {
			sb.append("dir=both,");
			sb.append("arrowtail=empty");
			sb.append(",arrowhead=empty");
		} else if (isEmpty1 && isEmpty2 == false) {
			sb.append("arrowtail=empty");
			sb.append(",arrowhead=none");
			sb.append(",dir=back");
			// } else if (isEmpty1 == false && isEmpty2) {
			// sb.append("arrowtail=none");
			// sb.append(",arrowhead=empty");
		}

		final double arrowsize = Math.max(decor1.getArrowSize(), decor2.getArrowSize());
		if (arrowsize > 0) {
			if (sb.length() > 0)
				sb.append(",");

			sb.append("arrowsize=" + arrowsize);
		}
		return sb.toString();
	}

	public final LinkDecor getDecor1() {
		return decor1;
	}

	public final LinkStyle getStyle() {
		return linkStyle;
	}

	public final LinkDecor getDecor2() {
		return decor2;
	}

	private boolean isExtendsOrAggregationOrCompositionOrPlus() {
		return isExtends() || isAggregationOrComposition() || isPlus() || isOf(LinkDecor.DEFINEDBY)
				|| isOf(LinkDecor.REDEFINES);
	}

	private boolean isExtendsOrPlus() {
		return isExtends() || isPlus() || isOf(LinkDecor.DEFINEDBY) || isOf(LinkDecor.REDEFINES);
	}

	private boolean isOf(LinkDecor ld) {
		return decor1 == ld || decor2 == ld;
	}

	public boolean isExtends() {
		return decor1 == LinkDecor.EXTENDS || decor2 == LinkDecor.EXTENDS;
	}

	private boolean isPlus() {
		return decor1 == LinkDecor.PLUS || decor2 == LinkDecor.PLUS;
	}

	private boolean isAggregationOrComposition() {
		return decor1 == LinkDecor.AGREGATION || decor2 == LinkDecor.AGREGATION || decor1 == LinkDecor.COMPOSITION
				|| decor2 == LinkDecor.COMPOSITION;
	}

	public LinkType getPart1() {
		return new LinkType(decor1, LinkDecor.NONE, middleDecor, linkStyle);
	}

	public LinkType getPart2() {
		return new LinkType(LinkDecor.NONE, decor2, middleDecor, linkStyle);
	}

	public UStroke getStroke3(UStroke defaultThickness) {
		if (linkStyle.isThicknessOverrided())
			return linkStyle.getStroke3();

		if (defaultThickness == null)
			return linkStyle.getStroke3();

		if (defaultThickness.getDashVisible() == 0 && defaultThickness.getDashSpace() == 0)
			return linkStyle.goThickness(defaultThickness.getThickness()).getStroke3();

		return defaultThickness;
	}

	public LinkMiddleDecor getMiddleDecor() {
		return middleDecor;
	}

	public LinkType withLollipopInterfaceEye2() {
		return new LinkType(LinkDecor.NONE, decor2, middleDecor, linkStyle);
	}

	public LinkType withLollipopInterfaceEye1() {
		return new LinkType(decor1, LinkDecor.NONE, middleDecor, linkStyle);
	}

}
