// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
/* +=======================================================================
 * |
 * |      PlantUML : a free UML diagram generator
 * |
 * +=======================================================================
 *
 * (C) Copyright 2009-2024, Arnaud Roques
 *
 * Project Info:  https://plantuml.com
 *
 * If you like this project or if you find it useful, you can support us at:
 *
 * https://plantuml.com/patreon (only 1$ per month!)
 * https://plantuml.com/liberapay (only 1€ per month!)
 * https://plantuml.com/paypal
 *
 *
 * PlantUML is free software; you can redistribute it and/or modify it
 * under the terms of the MIT License.
 *
 * See http://opensource.org/licenses/MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * PlantUML can occasionally display sponsored or advertising messages. Those
 * messages are usually generated on welcome or error images and never on
 * functional diagrams.
 * See https://plantuml.com/professional if you want to remove them
 *
 * Images (whatever their format : PNG, SVG, EPS...) generated by running PlantUML
 * are owned by the author of their corresponding sources code (that is, their
 * textual description in PlantUML language). Those images are not covered by
 * this MIT license.
 *
 * The generated images can then be used without any reference to the MIT license.
 * It is not even necessary to stipulate that they have been generated with PlantUML,
 * although this will be appreciated by the PlantUML team.
 *
 * There is an exception : if the textual description in PlantUML language is also covered
 * by any license, then the generated images are logically covered
 * by the very same license.
 *
 * This is the IGY distribution (Install GraphViz by Yourself).
 * You have to install GraphViz and to setup the GRAPHVIZ_DOT environment variable
 * (see https://plantuml.com/graphviz-dot )
 *
 * Icons provided by OpenIconic :  https://useiconic.com/open
 * Archimate sprites provided by Archi :  http://www.archimatetool.com
 * Stdlib AWS provided by https://github.com/milo-minderbinder/AWS-PlantUML
 * Stdlib Icons provided https://github.com/tupadr3/plantuml-icon-font-sprites
 * ASCIIMathML (c) Peter Jipsen http://www.chapman.edu/~jipsen
 * ASCIIMathML (c) David Lippman http://www.pierce.ctc.edu/dlippman
 * CafeUndZopfli ported by Eugene Klyuchnikov https://github.com/eustas/CafeUndZopfli
 * Brotli (c) by the Brotli Authors https://github.com/google/brotli
 * Themes (c) by Brett Schwarz https://github.com/bschwarz/puml-themes
 * Twemoji (c) by Twitter at https://twemoji.twitter.com/
 *
 */
package net.sourceforge.plantuml.ebnf;

import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FloatingNote;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.utils.Direction;

public class ETileBox extends ETile {

	private final String value;
	private final FontConfiguration fc;
	private final Style style;
	private final UText utext;
	private final HColorSet colorSet;
	private final Symbol symbol;
	private final ISkinParam skinParam;
	private String commentAbove;
	private String commentBelow;

	public ETileBox mergeWith(ETileBox other) {
		return new ETileBox(this.value + other.value, symbol, fc, style, colorSet, skinParam);
	}

	public ETileBox(String value, Symbol symbol, FontConfiguration fc, Style style, HColorSet colorSet,
			ISkinParam skinParam) {
		this.symbol = symbol;
		this.skinParam = skinParam;
		this.value = value;
		this.fc = fc;
		this.utext = UText.build(value, fc);
		this.style = style;
		this.colorSet = colorSet;
	}

	private double getPureH1(StringBounder stringBounder) {
		final double height = getTextDim(stringBounder).getHeight() + 10;
		return height / 2;
	}

	@Override
	public double getH1(StringBounder stringBounder) {
		double h1 = getPureH1(stringBounder);
		final TextBlock note = getNoteAbove(stringBounder);
		if (note != TextBlockUtils.EMPTY_TEXT_BLOCK)
			h1 += note.calculateDimension(stringBounder).getHeight() + 20;
		return h1;
	}

	@Override
	public double getH2(StringBounder stringBounder) {
		double h2 = getPureH1(stringBounder);
		final TextBlock note = getNoteBelow(stringBounder);
		if (note != TextBlockUtils.EMPTY_TEXT_BLOCK)
			h2 += note.calculateDimension(stringBounder).getHeight() + 20;
		return h2;
	}

	@Override
	public double getWidth(StringBounder stringBounder) {
		double width = getTextDim(stringBounder).getWidth() + 10;
		final TextBlock noteAbove = getNoteAbove(stringBounder);
		if (noteAbove != TextBlockUtils.EMPTY_TEXT_BLOCK)
			width = Math.max(width, noteAbove.calculateDimension(stringBounder).getWidth());

		final TextBlock noteBelow = getNoteBelow(stringBounder);
		if (noteBelow != TextBlockUtils.EMPTY_TEXT_BLOCK)
			width = Math.max(width, noteBelow.calculateDimension(stringBounder).getWidth());

		return width;
	}

	private XDimension2D getTextDim(StringBounder stringBounder) {
		return stringBounder.calculateDimension(fc.getFont(), value);
	}

	private XDimension2D getBoxDim(StringBounder stringBounder) {
		return getTextDim(stringBounder).delta(10);
	}

	@Override
	protected void addCommentAbove(String comment) {
		this.commentAbove = comment;
	}

	@Override
	protected void addCommentBelow(String comment) {
		this.commentBelow = comment;
	}

	@Override
	public void drawU(UGraphic ug) {
		final StringBounder stringBounder = ug.getStringBounder();
		final XDimension2D dim = calculateDimension(stringBounder);
		final XDimension2D dimText = getTextDim(stringBounder);
		final XDimension2D dimBox = getBoxDim(stringBounder);
		final HColor lineColor = style.value(PName.LineColor).asColor(colorSet);
		final HColor backgroundColor = style.value(PName.BackGroundColor).asColor(colorSet);

		final TextBlock noteAbove = getNoteAbove(stringBounder);
		final TextBlock noteBelow = getNoteBelow(stringBounder);
		final double posy = noteAbove == TextBlockUtils.EMPTY_TEXT_BLOCK ? 0
				: noteAbove.calculateDimension(stringBounder).getHeight() + 20;

		final double posxBox = (dim.getWidth() - dimBox.getWidth()) / 2;

		if (symbol == Symbol.TERMINAL_STRING1 || symbol == Symbol.TERMINAL_STRING2) {
			final URectangle rect = URectangle.build(dimBox);
			ug.apply(new UTranslate(posxBox, posy)).apply(lineColor).apply(UStroke.withThickness(0.5)).draw(rect);
		} else if (symbol == Symbol.SPECIAL_SEQUENCE) {
			final URectangle rect = URectangle.build(dimBox);
			ug.apply(new UTranslate(posxBox, posy)).apply(lineColor).apply(new UStroke(5, 5, 1)).draw(rect);
//			final URectangle rect1 = URectangle.build(dimBox.delta(2)).rounded(12);
//			final URectangle rect2 = URectangle.build(dimBox.delta(-2)).rounded(8);
//			ug.apply(new UTranslate(posxBox - 1, posy - 1)).apply(lineColor).apply(new UStroke(5.0, 5.0, 1.0)).draw(rect1);
//			ug.apply(new UTranslate(posxBox + 1, posy + 1)).apply(lineColor).apply(UStroke.withThickness(0.5)).draw(rect2);
		} else {
			final URectangle rect = URectangle.build(dimBox).rounded(10);
			ug.apply(new UTranslate(posxBox, posy)).apply(lineColor).apply(backgroundColor.bg()).apply(UStroke.withThickness(1.5))
					.draw(rect);
		}

		ug.apply(new UTranslate(5 + posxBox, posy + 5 + dimText.getHeight() - utext.getDescent(stringBounder)))
				.draw(utext);

		if (noteAbove != TextBlockUtils.EMPTY_TEXT_BLOCK) {
			final double posxAbove = (dim.getWidth() - noteAbove.calculateDimension(stringBounder).getWidth()) / 2;
			noteAbove.drawU(ug.apply(new UTranslate(posxAbove, 0)));
		}

		if (noteBelow != TextBlockUtils.EMPTY_TEXT_BLOCK) {
			final double posxBelow = (dim.getWidth() - noteBelow.calculateDimension(stringBounder).getWidth()) / 2;
			final double posyBelow = dim.getHeight() - noteBelow.calculateDimension(stringBounder).getHeight();
			noteBelow.drawU(ug.apply(new UTranslate(posxBelow, posyBelow)));
		}

		if (posxBox > 0) {
			drawHlineDirected(ug, getH1(stringBounder), 0, posxBox, .5);
			drawHlineDirected(ug, getH1(stringBounder), posxBox + dimBox.getWidth(), dim.getWidth(), .5);
		}

	}

	private TextBlock getNoteAbove(StringBounder stringBounder) {
		if (commentAbove == null)
			return TextBlockUtils.EMPTY_TEXT_BLOCK;

		final FloatingNote note = FloatingNote.createOpale(Display.getWithNewlines(commentAbove), skinParam,
				SName.ebnf);
		final XDimension2D dim = note.calculateDimension(stringBounder);
		final double pos = dim.getWidth() * .5;
		XPoint2D pp1 = new XPoint2D(pos, dim.getHeight());
		XPoint2D pp2 = new XPoint2D(pos, 20 + dim.getHeight());
		note.setOpale(Direction.DOWN, pp1, pp2);
		return note;
	}

	private TextBlock getNoteBelow(StringBounder stringBounder) {
		if (commentBelow == null)
			return TextBlockUtils.EMPTY_TEXT_BLOCK;

		final FloatingNote note = FloatingNote.createOpale(Display.getWithNewlines(commentBelow), skinParam,
				SName.ebnf);
		final XDimension2D dim = note.calculateDimension(stringBounder);
		final double pos = dim.getWidth() * .5;
		XPoint2D pp1 = new XPoint2D(pos, 0);
		XPoint2D pp2 = new XPoint2D(pos, -20);
		note.setOpale(Direction.UP, pp1, pp2);
		return note;
	}

	@Override
	public void push(ETile tile) {
		throw new UnsupportedOperationException();
	}

	@Override
	protected String getRepetitionLabel() {
		return value;
	}

	public final Symbol getSymbol() {
		return symbol;
	}

}
