// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.activitydiagram3.gtile;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.utils.MathUtils;

public class GtileColumns extends AbstractGtile {

	protected final List<Gtile> gtiles;

	private double margin;
	private double dy;

	protected final UTranslate getPosition(int pos) {
		double dx = 0;
		for (int i = 0; i < pos; i++) {
			final XDimension2D dim = gtiles.get(i).calculateDimension(getStringBounder());
			dx += dim.getWidth() + margin;
		}
		return new UTranslate(dx, dy);
	}

	protected final void setMargin(double margin) {
		if (margin < 0)
			throw new IllegalArgumentException("margin=" + margin);
		this.margin = margin;
	}

	protected final void pushDown(double height) {
		this.dy += height;
	}

	@Override
	public String toString() {
		return "GtileIfSimple " + gtiles;
	}

	public Gtile first() {
		return gtiles.get(0);
	}

	public GtileColumns(List<Gtile> gtiles, Swimlane singleSwimlane, double margin) {
		super(gtiles.get(0).getStringBounder(), gtiles.get(0).skinParam(), singleSwimlane);
		this.gtiles = gtiles;
		this.margin = margin;
	}

	@Override
	protected void drawUInternal(UGraphic ug) {
		for (int i = 0; i < gtiles.size(); i++) {
			final Gtile tile = gtiles.get(i);
			final UTranslate pos = getPosition(i);
			ug.apply(pos).draw(tile);
		}
	}

	@Override
	public XDimension2D calculateDimension(StringBounder stringBounder) {
		XDimension2D result = new XDimension2D(0, 0);
		for (int i = 0; i < gtiles.size(); i++) {
			final XDimension2D dim = gtiles.get(i).calculateDimension(stringBounder);
			final UTranslate pos = getPosition(i);
			final XDimension2D corner = dim.applyTranslate(pos);
			result = MathUtils.maxDim(result, corner);
		}
		return result;
	}

	public Set<Swimlane> getSwimlanes() {
		final Set<Swimlane> result = new HashSet<>();
		for (Gtile tile : gtiles)
			result.addAll(tile.getSwimlanes());
		return Collections.unmodifiableSet(result);
	}

//	public Collection<Gtile> getMyChildren() {
//		return Collections.unmodifiableCollection(gtiles);
//	}

}
