// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.board;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BArray implements Iterable<BNode> {

	private final Map<String, BNode> data = new HashMap<>();
	private int maxX;
	private int maxY;

	public void put(BNode node) {
		final String key = getKey(node.getX(), node.getStage());
		if (data.containsKey(key)) {
			throw new IllegalArgumentException();
		}
		data.put(key, node);
		this.maxX = Math.max(this.maxX, node.getX());
		this.maxY = Math.max(this.maxY, node.getStage());
	}

	public BNode getCell(int x, int y) {
		final String key = getKey(x, y);
		return data.get(key);
	}

	private String getKey(int x, int y) {
		return "" + x + ";" + y;
	}

	public Iterator<BNode> iterator() {
		return Collections.unmodifiableCollection(data.values()).iterator();
	}

	public final int getMaxX() {
		return maxX;
	}

	public final int getMaxY() {
		return maxY;
	}

}
