// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.file;

import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.security.SFile;

public class SuggestedFile {
	// ::remove file when __CORE__

	private final FileFormat fileFormat;
	private final int initialCpt;
	private final SFile outputFile;

	private SuggestedFile(SFile outputFile, FileFormat fileFormat, int initialCpt) {
		if (outputFile.getName().endsWith(fileFormat.getFileSuffix())) {
			throw new IllegalArgumentException();
		}
		this.outputFile = outputFile;
		this.fileFormat = fileFormat;
		this.initialCpt = initialCpt;
	}

	public SuggestedFile withPreprocFormat() {
		return new SuggestedFile(outputFile, FileFormat.PREPROC, initialCpt);
	}

	@Override
	public String toString() {
		return outputFile.getPrintablePath() + "[" + initialCpt + "]";
	}

	public static SuggestedFile fromOutputFile(SFile outputFile, FileFormat fileFormat) {
		return fromOutputFile(outputFile, fileFormat, 0);
	}

	public static SuggestedFile fromOutputFile(java.io.File outputFile, FileFormat fileFormat) {
		return fromOutputFile(outputFile, fileFormat, 0);
	}

	public SFile getParentFile() {
		return outputFile.getParentFile();
	}

	public String getName() {
		return outputFile.getName();
	}

	public SFile getFile(int cpt) {
		final String newName = fileFormat.changeName(outputFile.getName(), initialCpt + cpt);
		return outputFile.getParentFile().file(newName);
	}

	public static SuggestedFile fromOutputFile(SFile outputFile, FileFormat fileFormat, int initialCpt) {
		return new SuggestedFile(outputFile, fileFormat, initialCpt);
	}

	public static SuggestedFile fromOutputFile(java.io.File outputFile, FileFormat fileFormat, int initialCpt) {
		return new SuggestedFile(SFile.fromFile(outputFile), fileFormat, initialCpt);
	}

	public SFile getTmpFile() {
		return getParentFile().file(getName() + ".tmp");
	}

}
