// THIS FILE HAS BEEN GENERATED BY A PREPROCESSOR.
package net.sourceforge.plantuml.klimt.sprite;

import java.awt.image.BufferedImage;
import java.util.List;

import net.sourceforge.plantuml.text.BackSlash;

public class SpriteUtils {

	public static final String SPRITE_NAME = "[-\\p{L}0-9_/]+";

	private SpriteUtils() {
	}

	// ::comment when __CORE__
	public static String encodeColor(BufferedImage img, String name) {
		final StringBuilder sb = new StringBuilder();
		sb.append("sprite $" + name + " [" + img.getWidth() + "x" + img.getHeight() + "/color] {\n");
		final List<String> result = SpriteColorBuilder4096.encodeColor(img);
		for (String s : result) {
			sb.append(s);
			sb.append(BackSlash.NEWLINE);
		}
		sb.append("}\n");
		return sb.toString();
	}

	public static String encode(BufferedImage img, String name, SpriteGrayLevel level) {
		final StringBuilder sb = new StringBuilder();
		sb.append(
				"sprite $" + name + " [" + img.getWidth() + "x" + img.getHeight() + "/" + level.getNbColor() + "] {\n");
		final List<String> result = level.encode(img);
		for (String s : result) {
			sb.append(s);
			sb.append(BackSlash.NEWLINE);
		}
		sb.append("}\n");
		return sb.toString();
	}

	public static String encodeCompressed(BufferedImage img, String name, SpriteGrayLevel level) {
		final StringBuilder sb = new StringBuilder();
		sb.append("sprite $" + name + " [" + img.getWidth() + "x" + img.getHeight() + "/" + level.getNbColor() + "z] ");
		final List<String> list = level.encodeZ(img);
		if (list.size() == 1) {
			sb.append(list.get(0));
			sb.append(BackSlash.NEWLINE);
		} else {
			sb.append("{\n");
			for (String s : list) {
				sb.append(s);
				sb.append(BackSlash.NEWLINE);
			}
			sb.append("}\n");
		}
		return sb.toString();
	}

}
